/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.MediaTypes;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.JacksonHelper;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJson;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonAffordanceModel;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonDocument;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonItem;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonQuery;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonTemplate;
import org.springframework.hateoas.mediatype.collectionjson.CollectionRepresentationModelMixin;
import org.springframework.hateoas.mediatype.collectionjson.EntityRepresentationModelMixin;
import org.springframework.hateoas.mediatype.collectionjson.PagedResourcesMixin;
import org.springframework.hateoas.mediatype.collectionjson.RepresentationModelMixin;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.core.type.ResolvedType;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.deser.std.ContainerDeserializerBase;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.module.SimpleModule;
import tools.jackson.databind.ser.std.StdContainerSerializer;
import tools.jackson.databind.type.CollectionLikeType;
import tools.jackson.databind.type.CollectionType;
import tools.jackson.databind.type.TypeFactory;

public class CollectionJsonJacksonModule
extends SimpleModule {
    private static final long serialVersionUID = -6540574644565592709L;
    private static final TypeFactory TYPE_FACTORY = TypeFactory.createDefaultInstance();

    public CollectionJsonJacksonModule() {
        super("collection-json-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(EntityModel.class, EntityRepresentationModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionRepresentationModelMixin.class);
        this.setMixInAnnotation(PagedModel.class, PagedResourcesMixin.class);
        this.addSerializer((ValueSerializer)new CollectionJsonPagedResourcesSerializer());
        this.addSerializer((ValueSerializer)new CollectionJsonResourcesSerializer());
        this.addSerializer((ValueSerializer)new CollectionJsonResourceSerializer());
        this.addSerializer((ValueSerializer)new CollectionJsonResourceSupportSerializer());
        this.addSerializer((ValueSerializer)new CollectionJsonLinksSerializer());
        this.addDeserializer(Links.class, (ValueDeserializer)new CollectionJsonLinksDeserializer());
    }

    private static List<CollectionJsonItem<Object>> resourcesToCollectionJsonItems(CollectionModel<?> resources) {
        return resources.getContent().stream().map(content -> {
            if (!EntityModel.class.isInstance(content)) {
                return new CollectionJsonItem<Object>().withRawData(content);
            }
            EntityModel resource = (EntityModel)content;
            return new CollectionJsonItem().withHref(resource.getRequiredLink(IanaLinkRelations.SELF).getHref()).withLinks(resource.getLinks().without(IanaLinkRelations.SELF)).withRawData(resource.getContent());
        }).collect(Collectors.toList());
    }

    private static List<CollectionJsonQuery> findQueries(RepresentationModel<?> resource) {
        if (!resource.hasLink(IanaLinkRelations.SELF)) {
            return Collections.emptyList();
        }
        Link selfLink = resource.getRequiredLink(IanaLinkRelations.SELF);
        return selfLink.getAffordances().stream().map(it -> it.getAffordanceModel(MediaTypes.COLLECTION_JSON)).peek(it -> Assert.notNull((Object)it, (String)"No Collection/JSON affordance model found but expected!")).map(CollectionJsonAffordanceModel.class::cast).filter(it -> !it.hasHttpMethod(HttpMethod.GET)).filter(it -> !it.pointsToTargetOf(selfLink)).map(it -> new CollectionJsonQuery().withRel(it.getName()).withHref(it.getURI()).withData(it.getQueryProperties())).collect(Collectors.toList());
    }

    private static @Nullable CollectionJsonTemplate findTemplate(RepresentationModel<?> resource) {
        if (!resource.hasLink(IanaLinkRelations.SELF)) {
            return null;
        }
        return resource.getRequiredLink(IanaLinkRelations.SELF).getAffordances().stream().map(it -> it.getAffordanceModel(MediaTypes.COLLECTION_JSON)).map(CollectionJsonAffordanceModel.class::cast).filter(it -> !it.hasHttpMethod(HttpMethod.GET)).map(it -> new CollectionJsonTemplate().withData(it.getInputProperties())).findFirst().orElse(null);
    }

    static class CollectionJsonPagedResourcesSerializer
    extends StdContainerSerializer<PagedModel<?>> {
        private final @Nullable BeanProperty property;

        CollectionJsonPagedResourcesSerializer() {
            this(null);
        }

        CollectionJsonPagedResourcesSerializer(@Nullable BeanProperty property) {
            super(CollectionModel.class);
            this.property = property;
        }

        public void serialize(PagedModel<?> value, JsonGenerator jgen, SerializationContext context) {
            CollectionJson collectionJson = new CollectionJson().withVersion("1.0").withHref(value.getRequiredLink(IanaLinkRelations.SELF).getHref()).withLinks(value.getLinks().without(IanaLinkRelations.SELF)).withItems(CollectionJsonJacksonModule.resourcesToCollectionJsonItems(value)).withQueries(CollectionJsonJacksonModule.findQueries(value)).withTemplate(CollectionJsonJacksonModule.findTemplate(value));
            CollectionJsonDocument doc = new CollectionJsonDocument(collectionJson);
            context.findPrimaryPropertySerializer(CollectionJsonDocument.class, this.property).serialize(doc, jgen, context);
        }

        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            return new CollectionJsonPagedResourcesSerializer(property);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, PagedModel<?> value) {
            return value.getContent().isEmpty();
        }

        public boolean hasSingleElement(PagedModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    static class CollectionJsonResourcesSerializer
    extends StdContainerSerializer<CollectionModel<?>> {
        CollectionJsonResourcesSerializer() {
            super(CollectionModel.class);
        }

        public void serialize(CollectionModel<?> value, JsonGenerator jgen, SerializationContext context) {
            CollectionJson collectionJson = new CollectionJson().withVersion("1.0").withHref(value.getRequiredLink(IanaLinkRelations.SELF).getHref()).withLinks(value.getLinks().without(IanaLinkRelations.SELF)).withItems(CollectionJsonJacksonModule.resourcesToCollectionJsonItems(value)).withQueries(CollectionJsonJacksonModule.findQueries(value)).withTemplate(CollectionJsonJacksonModule.findTemplate(value));
            CollectionJsonDocument doc = new CollectionJsonDocument(collectionJson);
            context.findValueSerializer(CollectionJsonDocument.class).serialize(doc, jgen, context);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext provider, CollectionModel<?> value) {
            return value.getContent().isEmpty();
        }

        public boolean hasSingleElement(CollectionModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    static class CollectionJsonResourceSerializer
    extends StdContainerSerializer<EntityModel<?>> {
        private final @Nullable BeanProperty property;

        CollectionJsonResourceSerializer() {
            this(null);
        }

        CollectionJsonResourceSerializer(@Nullable BeanProperty property) {
            super(EntityModel.class);
            this.property = property;
        }

        public void serialize(EntityModel<?> value, JsonGenerator gen, SerializationContext provider) throws JacksonException {
            String href = value.getRequiredLink(IanaLinkRelations.SELF).getHref();
            Links withoutSelfLink = value.getLinks().without(IanaLinkRelations.SELF);
            CollectionJson collectionJson = new CollectionJson().withVersion("1.0").withHref(href).withLinks(withoutSelfLink).withItems(new CollectionJsonItem().withHref(href).withLinks(withoutSelfLink).withRawData(value.getContent())).withQueries(CollectionJsonJacksonModule.findQueries(value)).withTemplate(CollectionJsonJacksonModule.findTemplate(value));
            CollectionJsonDocument doc = new CollectionJsonDocument(collectionJson);
            provider.findPrimaryPropertySerializer(CollectionJsonDocument.class, this.property).serialize(doc, gen, provider);
        }

        public ValueSerializer<?> createContextual(SerializationContext ctxt, BeanProperty property) {
            return new CollectionJsonResourceSerializer(property);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, EntityModel<?> value) {
            return false;
        }

        public boolean hasSingleElement(EntityModel<?> value) {
            return true;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    static class CollectionJsonResourceSupportSerializer
    extends StdContainerSerializer<RepresentationModel<?>> {
        private final @Nullable BeanProperty property;

        CollectionJsonResourceSupportSerializer() {
            this(null);
        }

        CollectionJsonResourceSupportSerializer(@Nullable BeanProperty property) {
            super(RepresentationModel.class);
            this.property = property;
        }

        public void serialize(RepresentationModel<?> value, JsonGenerator jgen, SerializationContext context) {
            String href = value.getRequiredLink(IanaLinkRelations.SELF.value()).getHref();
            CollectionJson collectionJson = new CollectionJson().withVersion("1.0").withHref(href).withLinks(value.getLinks().without(IanaLinkRelations.SELF)).withQueries(CollectionJsonJacksonModule.findQueries(value)).withTemplate(CollectionJsonJacksonModule.findTemplate(value));
            CollectionJsonItem<RepresentationModel<?>> item = new CollectionJsonItem().withHref(href).withLinks(value.getLinks().without(IanaLinkRelations.SELF)).withRawData(value);
            if (!item.getData().isEmpty()) {
                collectionJson = collectionJson.withItems(item);
            }
            CollectionJsonDocument doc = new CollectionJsonDocument(collectionJson);
            context.findPrimaryPropertySerializer(CollectionJsonDocument.class, this.property).serialize(doc, jgen, context);
        }

        public ValueSerializer<?> createContextual(SerializationContext prov, BeanProperty property) {
            return new CollectionJsonResourceSupportSerializer(property);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean isEmpty(SerializationContext prov, RepresentationModel<?> value) {
            return false;
        }

        public boolean hasSingleElement(RepresentationModel<?> value) {
            return true;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    static class CollectionJsonLinksSerializer
    extends StdContainerSerializer<Links> {
        CollectionJsonLinksSerializer() {
            super(Links.class);
        }

        public void serialize(Links links, JsonGenerator jgen, SerializationContext provider) {
            CollectionType type = provider.getTypeFactory().constructCollectionType(List.class, Link.class);
            provider.findValueSerializer((JavaType)type).serialize(links.toList(), jgen, provider);
        }

        public boolean isEmpty(SerializationContext provider, Links value) {
            return value.isEmpty();
        }

        public JavaType getContentType() {
            return TYPE_FACTORY.constructType(Link.class);
        }

        public @Nullable ValueSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(Links value) {
            return false;
        }

        protected @Nullable StdContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }
    }

    static class CollectionJsonLinksDeserializer
    extends ContainerDeserializerBase<Links> {
        CollectionJsonLinksDeserializer() {
            super((JavaType)TYPE_FACTORY.constructCollectionLikeType(List.class, Link.class));
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public Links deserialize(JsonParser jp, DeserializationContext ctx) {
            CollectionLikeType type = ctx.getTypeFactory().constructCollectionLikeType(List.class, Link.class);
            return Links.of((Iterable)jp.readValueAs((ResolvedType)type));
        }
    }

    static class CollectionJsonPagedResourcesDeserializer
    extends CollectionValueDeserializerBase<PagedModel<?>> {
        private static final BiFunction<List<Object>, Links, PagedModel<?>> FINISHER = (content, links) -> PagedModel.of(content, null, links);
        private static final Function<JavaType, CollectionValueDeserializerBase<PagedModel<?>>> CONTEXTUAL_CREATOR = CollectionJsonPagedResourcesDeserializer::new;

        CollectionJsonPagedResourcesDeserializer() {
            super(FINISHER, CONTEXTUAL_CREATOR);
        }

        private CollectionJsonPagedResourcesDeserializer(JavaType contentType) {
            super(contentType, FINISHER, CONTEXTUAL_CREATOR);
        }
    }

    static class CollectionJsonResourcesDeserializer
    extends CollectionValueDeserializerBase<CollectionModel<?>> {
        private static final BiFunction<List<Object>, Links, CollectionModel<?>> FINISHER = CollectionModel::of;
        private static final Function<JavaType, CollectionValueDeserializerBase<CollectionModel<?>>> CONTEXTUAL_CREATOR = CollectionJsonResourcesDeserializer::new;

        CollectionJsonResourcesDeserializer() {
            super(FINISHER, CONTEXTUAL_CREATOR);
        }

        private CollectionJsonResourcesDeserializer(JavaType contentType) {
            super(contentType, FINISHER, CONTEXTUAL_CREATOR);
        }
    }

    static abstract class CollectionValueDeserializerBase<T extends CollectionModel<?>>
    extends ContainerDeserializerBase<T> {
        private final JavaType contentType;
        private final BiFunction<List<Object>, Links, T> finalizer;
        private final Function<JavaType, CollectionValueDeserializerBase<T>> creator;

        CollectionValueDeserializerBase(BiFunction<List<Object>, Links, T> finalizer, Function<JavaType, CollectionValueDeserializerBase<T>> creator) {
            this(TYPE_FACTORY.constructType(CollectionJson.class), finalizer, creator);
        }

        private CollectionValueDeserializerBase(JavaType contentType, BiFunction<List<Object>, Links, T> finalizer, Function<JavaType, CollectionValueDeserializerBase<T>> creator) {
            super(contentType);
            this.contentType = contentType;
            this.finalizer = finalizer;
            this.creator = creator;
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, @Nullable BeanProperty property) {
            JavaType contextualType = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return (ValueDeserializer)this.creator.apply(contextualType);
        }

        public T deserialize(JsonParser parser, DeserializationContext ctxt) {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            JavaType wrappedType = ctxt.getTypeFactory().constructParametricType(CollectionJsonDocument.class, new JavaType[]{rootType});
            CollectionJsonDocument document = (CollectionJsonDocument)parser.readValueAs((ResolvedType)wrappedType);
            CollectionJson collection = document.getCollection().withOwnSelfLink();
            Links links = collection.getLinks();
            if (!collection.hasItems() || !this.contentType.hasGenericTypes()) {
                return (T)((CollectionModel)this.finalizer.apply(Collections.emptyList(), links));
            }
            boolean isResource = this.contentType.hasGenericTypes() && this.contentType.containedType(0).hasRawClass(EntityModel.class);
            return (T)collection.getItems().stream().map(CollectionJsonItem::withOwnSelfLink).map(it -> isResource ? RepresentationModel.of(it.toRawData(rootType), it.getLinks()) : it.toRawData(rootType)).collect(Collectors.collectingAndThen(Collectors.toList(), it -> (CollectionModel)this.finalizer.apply((List<Object>)it, links)));
        }
    }

    static class CollectionJsonResourceDeserializer
    extends ContainerDeserializerBase<EntityModel<?>> {
        private final JavaType contentType;

        CollectionJsonResourceDeserializer() {
            this(TYPE_FACTORY.constructType(CollectionJson.class));
        }

        CollectionJsonResourceDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public EntityModel<?> deserialize(JsonParser jp, DeserializationContext ctxt) {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            JavaType wrappedType = ctxt.getTypeFactory().constructParametricType(CollectionJsonDocument.class, new JavaType[]{rootType});
            CollectionJsonDocument document = (CollectionJsonDocument)jp.readValueAs((ResolvedType)wrappedType);
            CollectionJson collection = document.getCollection();
            List items = collection.getItems();
            Links links = collection.withOwnSelfLink().getLinks();
            CollectionJsonTemplate template = collection.getTemplate();
            if (items.isEmpty() && template != null) {
                Map<String, Object> properties = template.getData().stream().collect(Collectors.toMap(CollectionJsonData::getName, CollectionJsonData::getValue));
                Object obj = PropertyUtils.createObjectFromProperties(rootType.getRawClass(), properties);
                return EntityModel.of(obj, links);
            }
            Links merged = items.stream().map(CollectionJsonItem::getLinks).reduce(links, (left, right) -> left.merge(Links.MergeMode.REPLACE_BY_REL, (Iterable<Link>)right), (left, right) -> right);
            CollectionJsonItem firstItem = items.get(0).withOwnSelfLink();
            return EntityModel.of(firstItem.toRawData(rootType), merged.merge(Links.MergeMode.REPLACE_BY_REL, firstItem.getLinks()));
        }

        public ValueDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) {
            return new CollectionJsonResourceDeserializer(property == null ? ctxt.getContextualType() : property.getType().getContentType());
        }
    }

    static class CollectionJsonResourceSupportDeserializer
    extends ContainerDeserializerBase<RepresentationModel<?>> {
        private final JavaType contentType;

        CollectionJsonResourceSupportDeserializer() {
            this(TYPE_FACTORY.constructType(RepresentationModel.class));
        }

        CollectionJsonResourceSupportDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public @Nullable ValueDeserializer<Object> getContentDeserializer() {
            return null;
        }

        public @Nullable RepresentationModel<?> deserialize(JsonParser jp, DeserializationContext ctxt) {
            TypeFactory typeFactory = ctxt.getTypeFactory();
            JavaType rootType = typeFactory.constructSimpleType(Object.class, new JavaType[0]);
            JavaType wrappedType = typeFactory.constructParametricType(CollectionJsonDocument.class, new JavaType[]{rootType});
            CollectionJsonDocument document = (CollectionJsonDocument)jp.readValueAs((ResolvedType)wrappedType);
            CollectionJson collection = document.getCollection();
            List items = collection.getItems();
            Links links = collection.getLinks();
            CollectionJson withOwnSelfLink = collection.withOwnSelfLink();
            if (!items.isEmpty()) {
                Links merged = items.stream().map(CollectionJsonItem::getLinks).reduce(links, (left, right) -> left.merge((Iterable<Link>)right), (left, right) -> right);
                CollectionJsonItem firstItem = items.get(0).withOwnSelfLink();
                RepresentationModel resource = (RepresentationModel)firstItem.toRawData(this.contentType);
                if (resource != null) {
                    resource.add(firstItem.getLinks().merge(merged));
                }
                return resource;
            }
            CollectionJsonTemplate template = withOwnSelfLink.getTemplate();
            if (template != null) {
                Map<String, Object> properties = template.getData().stream().collect(Collectors.toMap(CollectionJsonData::getName, CollectionJsonData::getValue));
                RepresentationModel resourceSupport = (RepresentationModel)PropertyUtils.createObjectFromProperties(this.contentType.getRawClass(), properties);
                return resourceSupport.add(withOwnSelfLink.getLinks());
            }
            return new RepresentationModel().add(withOwnSelfLink.getLinks());
        }

        public ValueDeserializer<?> createContextual(DeserializationContext context, @Nullable BeanProperty property) {
            JavaType type = property == null ? context.getContextualType() : property.getType().getContentType();
            return new CollectionJsonResourceSupportDeserializer(type);
        }
    }
}

