/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.util.Map;
import org.jspecify.annotations.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.web.util.UriTemplate;

public class UriTemplateFactory {
    private static final Map<String, UriTemplate> CACHE = new ConcurrentReferenceHashMap();

    public static UriTemplate templateFor(@Nullable String mapping) {
        Assert.hasText((String)mapping, (String)"Mapping must not be null or empty!");
        return CACHE.computeIfAbsent(mapping, UriTemplate::new);
    }
}

