/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.NullUnmarked;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsOptions;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@NullUnmarked
final class HalFormsProperty
implements AffordanceModel.Named {
    private final String name;
    private final String prompt;
    private final String regex;
    private final String placeholder;
    private final Object value;
    private final boolean templated;
    private final boolean multi;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean readOnly;
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    private final boolean required;
    private final @Nullable Number min;
    private final @Nullable Number max;
    private final @Nullable Long minLength;
    private final @Nullable Long maxLength;
    private final @Nullable String type;
    private final @Nullable HalFormsOptions options;

    HalFormsProperty() {
        this.name = null;
        this.readOnly = false;
        this.value = null;
        this.prompt = null;
        this.regex = null;
        this.templated = false;
        this.required = false;
        this.multi = false;
        this.placeholder = null;
        this.min = null;
        this.max = null;
        this.minLength = null;
        this.maxLength = null;
        this.type = null;
        this.options = null;
    }

    private HalFormsProperty(String name, boolean readOnly, @Nullable Object value, String prompt, String regex, boolean templated, boolean required, boolean multi, String placeholder, @Nullable Number min, @Nullable Number max, @Nullable Long minLength, @Nullable Long maxLength, @Nullable String type, @Nullable HalFormsOptions options) {
        Assert.notNull((Object)name, (String)"Name must not be null!");
        this.name = name;
        this.readOnly = readOnly;
        this.value = value;
        this.prompt = StringUtils.hasText((String)prompt) ? prompt : null;
        this.regex = regex;
        this.templated = templated;
        this.required = required;
        this.multi = multi;
        this.placeholder = StringUtils.hasText((String)placeholder) ? placeholder : null;
        this.min = min;
        this.max = max;
        this.minLength = minLength;
        this.maxLength = maxLength;
        this.type = type;
        this.options = options;
    }

    static HalFormsProperty named(String name) {
        return new HalFormsProperty().withName(name);
    }

    HalFormsProperty withName(String name) {
        Assert.notNull((Object)name, (String)"name must not be null!");
        return this.name == name ? this : new HalFormsProperty(name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withReadOnly(boolean readOnly) {
        return this.readOnly == readOnly ? this : new HalFormsProperty(this.name, readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withValue(@Nullable Object value) {
        return this.value == value ? this : new HalFormsProperty(this.name, this.readOnly, value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withPrompt(String prompt) {
        return this.prompt == prompt ? this : new HalFormsProperty(this.name, this.readOnly, this.value, prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withRegex(String regex) {
        return this.regex == regex ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withRegex(Optional<String> regex) {
        return regex.map(it -> this.withRegex((String)it)).orElse(this);
    }

    HalFormsProperty withTemplated(boolean templated) {
        return this.templated == templated ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withRequired(boolean required) {
        return this.required == required ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withMulti(boolean multi) {
        return this.multi == multi ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withPlaceholder(String placeholder) {
        return this.placeholder == placeholder ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withMin(@Nullable Number min) {
        return Objects.equals(this.min, min) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withMax(@Nullable Number max) {
        return Objects.equals(this.max, max) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, max, this.minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withMinLength(@Nullable Long minLength) {
        return Objects.equals(this.minLength, minLength) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, minLength, this.maxLength, this.type, this.options);
    }

    HalFormsProperty withMaxLength(@Nullable Long maxLength) {
        return Objects.equals(this.maxLength, maxLength) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, maxLength, this.type, this.options);
    }

    HalFormsProperty withType(@Nullable String type) {
        return Objects.equals(this.type, type) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, type, this.options);
    }

    HalFormsProperty withOptions(@Nullable HalFormsOptions options) {
        return Objects.equals(this.options, options) ? this : new HalFormsProperty(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, options);
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    boolean isReadOnly() {
        return this.readOnly;
    }

    @JsonProperty
    Object getValue() {
        return this.value;
    }

    @JsonProperty
    String getPrompt() {
        return this.prompt;
    }

    @JsonProperty
    String getRegex() {
        return this.regex;
    }

    @JsonIgnore
    boolean hasRegex() {
        return StringUtils.hasText((String)this.regex);
    }

    @JsonProperty
    boolean isTemplated() {
        return this.templated;
    }

    @JsonProperty
    boolean isRequired() {
        return this.required;
    }

    @JsonProperty
    boolean isMulti() {
        return this.multi;
    }

    @JsonProperty
    public String getPlaceholder() {
        return this.placeholder;
    }

    @JsonProperty
    public @Nullable Number getMin() {
        return this.min;
    }

    @JsonProperty
    public @Nullable Number getMax() {
        return this.max;
    }

    @JsonProperty
    public @Nullable Long getMinLength() {
        return this.minLength;
    }

    @JsonProperty
    @Nullable Long getMaxLength() {
        return this.maxLength;
    }

    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable String getType() {
        return this.type;
    }

    @JsonProperty
    @Nullable HalFormsOptions getOptions() {
        return this.options;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsProperty)) {
            return false;
        }
        HalFormsProperty that = (HalFormsProperty)o;
        return this.readOnly == that.readOnly && this.templated == that.templated && this.required == that.required && this.multi == that.multi && Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.prompt, that.prompt) && Objects.equals(this.regex, that.regex) && Objects.equals(this.placeholder, that.placeholder) && Objects.equals(this.type, that.type) && Objects.equals(this.options, that.options);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.readOnly, this.value, this.prompt, this.regex, this.templated, this.required, this.multi, this.placeholder, this.min, this.max, this.minLength, this.maxLength, this.type, this.options);
    }

    public String toString() {
        return "HalFormsProperty(name=" + this.name + ", readOnly=" + this.readOnly + ", value=" + String.valueOf(this.value) + ", prompt=" + this.prompt + ", regex=" + this.regex + ", templated=" + this.templated + ", required=" + this.required + ", multi=" + this.multi + ", placeholder=" + this.placeholder + ", min=" + String.valueOf(this.min) + ", max=" + String.valueOf(this.max) + ", minLength=" + this.minLength + ", maxLength=" + this.maxLength + ", type=" + this.type + ", options=" + String.valueOf(this.options) + ")";
    }
}

