/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.lang.reflect.Type;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.http.MediaType;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.Assert;

public class TypeConstrainedMappingJackson2HttpMessageConverter
extends MappingJackson2HttpMessageConverter {
    private final Class<?> type;

    public TypeConstrainedMappingJackson2HttpMessageConverter(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        this.type = type;
    }

    public TypeConstrainedMappingJackson2HttpMessageConverter(Class<?> type, List<MediaType> supportedMediaTypes, ObjectMapper objectMapper) {
        this(type);
        this.setSupportedMediaTypes(supportedMediaTypes);
        this.setObjectMapper(objectMapper);
    }

    public boolean canRead(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canRead(clazz, mediaType);
    }

    public boolean canRead(Type type, @Nullable Class<?> contextClass, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(this.getJavaType(type, contextClass).getRawClass()) && super.canRead(type, contextClass, mediaType);
    }

    public boolean canWrite(Class<?> clazz, @Nullable MediaType mediaType) {
        return this.type.isAssignableFrom(clazz) && super.canWrite(clazz, mediaType);
    }
}

