/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.uber;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.ContainerSerializer;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.Nullable;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.JacksonHelper;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.uber.Uber;
import org.springframework.hateoas.mediatype.uber.UberAction;
import org.springframework.hateoas.mediatype.uber.UberData;
import org.springframework.hateoas.mediatype.uber.UberDocument;
import org.springframework.util.StringUtils;

public class Jackson2UberModule
extends SimpleModule {
    private static final long serialVersionUID = -2396790508486870880L;

    public Jackson2UberModule() {
        super("uber-module", new Version(1, 0, 0, null, "org.springframework.hateoas", "spring-hateoas"));
        this.addSerializer((JsonSerializer)new UberPagedModelSerializer());
        this.addSerializer((JsonSerializer)new UberCollectionModelSerializer());
        this.addSerializer((JsonSerializer)new UberEntityModelSerializer());
        this.addSerializer((JsonSerializer)new UberRepresentationModelSerializer());
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(EntityModel.class, EntityModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
        this.setMixInAnnotation(PagedModel.class, PagedModelMixin.class);
    }

    private static CollectionModel<?> extractResources(UberDocument doc, JavaType rootType, JavaType contentType) {
        ArrayList content = new ArrayList();
        for (UberData uberData : doc.getUber().getData()) {
            String name = uberData.getName();
            if (name != null && name.equals("page") || !uberData.getLinks().isEmpty()) continue;
            ArrayList<Link> resourceLinks = new ArrayList<Link>();
            RepresentationModel<?> resource = null;
            List<UberData> data = uberData.getData();
            if (data == null) {
                throw new RuntimeException("No content!");
            }
            for (UberData item2 : data) {
                List<LinkRelation> rel = item2.getRel();
                if (rel != null) {
                    resourceLinks.addAll(item2.getLinks());
                    continue;
                }
                List<UberData> itemData = item2.getData();
                if (Jackson2UberModule.isPrimitiveType(itemData)) {
                    if (itemData == null) {
                        throw new IllegalStateException();
                    }
                    UberData firstItem = itemData.get(0);
                    Object scalarValue = firstItem.getValue();
                    resource = RepresentationModel.of(scalarValue, uberData.getLinks());
                    continue;
                }
                HashMap<String, Object> properties = itemData == null ? new HashMap<String, Object>() : itemData.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
                Object obj = PropertyUtils.createObjectFromProperties(rootType.getRawClass(), properties);
                resource = EntityModel.of(obj, uberData.getLinks());
            }
            if (resource != null) {
                resource.add(resourceLinks);
                content.add(resource);
                continue;
            }
            throw new RuntimeException("No content!");
        }
        if (JacksonHelper.isResourcesOfResource(contentType)) {
            return CollectionModel.of(content, (Iterable<Link>)doc.getUber().getLinks());
        }
        List resourceLessContent = content.stream().map(item -> (EntityModel)item).map(EntityModel::getContent).collect(Collectors.toList());
        return CollectionModel.of(resourceLessContent, (Iterable<Link>)doc.getUber().getLinks());
    }

    private static boolean isPrimitiveType(@Nullable List<UberData> data) {
        return data != null && data.size() == 1 && data.get(0).getName() == null;
    }

    private static @Nullable PagedModel.PageMetadata extractPagingMetadata(UberDocument doc) {
        return doc.getUber().getData().stream().filter(uberData -> Optional.ofNullable(uberData.getName()).map("page"::equals).orElse(false)).findFirst().map(Jackson2UberModule::convertUberDataToPageMetaData).orElse(null);
    }

    private static PagedModel.PageMetadata convertUberDataToPageMetaData(UberData uberData) {
        int size = 0;
        int number = 0;
        int totalElements = 0;
        int totalPages = 0;
        List<UberData> content = uberData.getData();
        if (content != null) {
            for (UberData data : content) {
                String name = data.getName();
                Object value = data.getValue();
                switch (name) {
                    case "size": {
                        size = (Integer)value;
                        break;
                    }
                    case "number": {
                        number = (Integer)value;
                        break;
                    }
                    case "totalElements": {
                        totalElements = (Integer)value;
                        break;
                    }
                    case "totalPages": {
                        totalPages = (Integer)value;
                        break;
                    }
                }
            }
        }
        return new PagedModel.PageMetadata(size, number, totalElements, totalPages);
    }

    static class UberPagedModelSerializer
    extends ContainerSerializer<PagedModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -7892297813593085984L;
        private @Nullable BeanProperty property;

        UberPagedModelSerializer(@Nullable BeanProperty property) {
            super(PagedModel.class, false);
            this.property = property;
        }

        UberPagedModelSerializer() {
            this(null);
        }

        public void serialize(PagedModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findValueSerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(PagedModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) {
            return new UberPagedModelSerializer(property);
        }
    }

    static class UberCollectionModelSerializer
    extends ContainerSerializer<CollectionModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = 3422019794262694127L;
        private @Nullable BeanProperty property;

        UberCollectionModelSerializer(@Nullable BeanProperty property) {
            super(CollectionModel.class, false);
            this.property = property;
        }

        UberCollectionModelSerializer() {
            this(null);
        }

        public void serialize(CollectionModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findValueSerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(CollectionModel<?> value) {
            return value.getContent().size() == 1;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new UberCollectionModelSerializer(property);
        }
    }

    static class UberEntityModelSerializer
    extends ContainerSerializer<EntityModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -5538560800604582741L;
        private final @Nullable BeanProperty property;

        UberEntityModelSerializer(@Nullable BeanProperty property) {
            super(EntityModel.class, false);
            this.property = property;
        }

        UberEntityModelSerializer() {
            this(null);
        }

        public void serialize(EntityModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findValueSerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(EntityModel<?> value) {
            return false;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new UberEntityModelSerializer(property);
        }
    }

    static class UberRepresentationModelSerializer
    extends ContainerSerializer<RepresentationModel<?>>
    implements ContextualSerializer {
        private static final long serialVersionUID = -572866287910993300L;
        private final @Nullable BeanProperty property;

        UberRepresentationModelSerializer(@Nullable BeanProperty property) {
            super(RepresentationModel.class, false);
            this.property = property;
        }

        UberRepresentationModelSerializer() {
            this(null);
        }

        public void serialize(RepresentationModel<?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            UberDocument doc = new UberDocument().withUber(new Uber().withVersion("1.0").withData(UberData.extractLinksAndContent(value)));
            provider.findValueSerializer(UberDocument.class, this.property).serialize((Object)doc, gen, provider);
        }

        public @Nullable JavaType getContentType() {
            return null;
        }

        public @Nullable JsonSerializer<?> getContentSerializer() {
            return null;
        }

        public boolean hasSingleElement(RepresentationModel<?> value) {
            return false;
        }

        protected @Nullable ContainerSerializer<?> _withValueTypeSerializer(TypeSerializer vts) {
            return null;
        }

        public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
            return new UberRepresentationModelSerializer(property);
        }
    }

    @JsonDeserialize(using=UberRepresentationModelDeserializer.class)
    abstract class RepresentationModelMixin
    extends RepresentationModel<RepresentationModelMixin> {
        RepresentationModelMixin() {
        }
    }

    @JsonDeserialize(using=UberEntityModelDeserializer.class)
    abstract class EntityModelMixin<T>
    extends EntityModel<T> {
        EntityModelMixin() {
        }
    }

    @JsonDeserialize(using=UberCollectionModelDeserializer.class)
    abstract class CollectionModelMixin<T>
    extends CollectionModel<T> {
        CollectionModelMixin() {
        }
    }

    @JsonDeserialize(using=UberPagedModelDeserializer.class)
    abstract class PagedModelMixin<T>
    extends PagedModel<T> {
        PagedModelMixin() {
        }
    }

    static class UberActionDeserializer
    extends StdDeserializer<UberAction> {
        private static final long serialVersionUID = -6198451472474285487L;

        UberActionDeserializer() {
            super(UberAction.class);
        }

        public UberAction deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return UberAction.valueOf(p.getText().toUpperCase());
        }
    }

    static class UberPagedModelDeserializer
    extends ContainerDeserializerBase<PagedModel<?>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 4123359694609188745L;
        private JavaType contentType;

        UberPagedModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        UberPagedModelDeserializer() {
            this(TypeFactory.defaultInstance().constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        public PagedModel<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            UberDocument doc = (UberDocument)p.getCodec().readValue(p, UberDocument.class);
            CollectionModel<?> resources = Jackson2UberModule.extractResources(doc, rootType, this.contentType);
            PagedModel.PageMetadata pageMetadata = Jackson2UberModule.extractPagingMetadata(doc);
            return PagedModel.of(resources.getContent(), pageMetadata, resources.getLinks());
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberPagedModelDeserializer(type);
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberCollectionModelDeserializer
    extends ContainerDeserializerBase<CollectionModel<?>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 8722467561709171145L;
        private final JavaType contentType;

        UberCollectionModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        UberCollectionModelDeserializer() {
            this(TypeFactory.defaultInstance().constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        public CollectionModel<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            UberDocument doc = (UberDocument)p.getCodec().readValue(p, UberDocument.class);
            return Jackson2UberModule.extractResources(doc, rootType, this.contentType);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberCollectionModelDeserializer(type);
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberEntityModelDeserializer
    extends ContainerDeserializerBase<RepresentationModel<?>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = 1776321413269082414L;
        private final JavaType contentType;

        UberEntityModelDeserializer() {
            this(TypeFactory.defaultInstance().constructSimpleType(UberDocument.class, new JavaType[0]));
        }

        private UberEntityModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public RepresentationModel<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            UberDocument doc = (UberDocument)p.getCodec().readValue(p, UberDocument.class);
            Links links = doc.getUber().getLinks();
            return doc.getUber().getData().stream().filter(uberData -> !StringUtils.isEmpty((Object)uberData.getName())).findFirst().map(uberData -> this.convertToResource((UberData)uberData, links)).orElseThrow(() -> new IllegalStateException("No data entry containing a 'value' was found in this document!"));
        }

        private RepresentationModel<?> convertToResource(UberData uberData, Links links) {
            List<UberData> data = uberData.getData();
            if (data == null) {
                throw new IllegalStateException();
            }
            if (Jackson2UberModule.isPrimitiveType(data)) {
                UberData firstItem = data.get(0);
                Object scalarValue = firstItem.getValue();
                return RepresentationModel.of(scalarValue, links);
            }
            HashMap<String, Object> properties = data == null ? new HashMap<String, Object>() : data.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
            JavaType rootType = JacksonHelper.findRootType(this.contentType);
            Object value = PropertyUtils.createObjectFromProperties(rootType.getRawClass(), properties);
            return EntityModel.of(value, links);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberEntityModelDeserializer(type);
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }

    static class UberRepresentationModelDeserializer
    extends ContainerDeserializerBase<RepresentationModel<?>>
    implements ContextualDeserializer {
        private static final long serialVersionUID = -8738539821441549016L;
        private final JavaType contentType;

        UberRepresentationModelDeserializer() {
            this(TypeFactory.defaultInstance().constructType(RepresentationModel.class));
        }

        private UberRepresentationModelDeserializer(JavaType contentType) {
            super(contentType);
            this.contentType = contentType;
        }

        public RepresentationModel<?> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            UberDocument doc = (UberDocument)p.getCodec().readValue(p, UberDocument.class);
            Links links = doc.getUber().getLinks();
            RepresentationModel result = doc.getUber().getData().stream().filter(uberData -> !StringUtils.isEmpty((Object)uberData.getName())).findFirst().map(uberData -> this.convertToResourceSupport((UberData)uberData, links)).orElse(null);
            return result == null ? new RepresentationModel().add(links) : result;
        }

        @NotNull
        private RepresentationModel<?> convertToResourceSupport(UberData uberData, Links links) {
            List<UberData> data = uberData.getData();
            Map<Object, Object> properties = data == null ? new HashMap() : data.stream().collect(Collectors.toMap(UberData::getName, UberData::getValue));
            RepresentationModel resourceSupport = (RepresentationModel)PropertyUtils.createObjectFromProperties(this.getContentType().getRawClass(), properties);
            return resourceSupport.add(links);
        }

        public JavaType getContentType() {
            return this.contentType;
        }

        public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
            JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
            return new UberRepresentationModelDeserializer(type);
        }

        public @Nullable JsonDeserializer<Object> getContentDeserializer() {
            return null;
        }
    }
}

