/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.lang.Nullable;

final class CollectionJsonTemplate {
    private final List<CollectionJsonData> data;

    @JsonCreator
    CollectionJsonTemplate(@JsonProperty(value="data") @Nullable List<CollectionJsonData> data) {
        this.data = data;
    }

    CollectionJsonTemplate() {
        this(null);
    }

    public CollectionJsonTemplate withData(List<CollectionJsonData> data) {
        return this.data == data ? this : new CollectionJsonTemplate(data);
    }

    public List<CollectionJsonData> getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionJsonTemplate that = (CollectionJsonTemplate)o;
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        return Objects.hash(this.data);
    }

    public String toString() {
        return "CollectionJsonTemplate(data=" + String.valueOf(this.data) + ")";
    }
}

