/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsProperty;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NON_PRIVATE)
@JsonIgnoreProperties(value={"httpMethod", "contentTypes"})
@JsonPropertyOrder(value={"title", "method", "contentType", "properties"})
final class HalFormsTemplate {
    static final String DEFAULT_KEY = "default";
    private String title;
    private HttpMethod httpMethod;
    private List<HalFormsProperty> properties;
    private MediaType contentType;
    private String target;

    private HalFormsTemplate() {
        this(null, null, Collections.emptyList(), null, null);
    }

    private HalFormsTemplate(String title, HttpMethod httpMethod, List<HalFormsProperty> properties, @Nullable MediaType contentType, String target) {
        this.title = title;
        this.httpMethod = httpMethod;
        this.properties = properties;
        this.contentType = contentType;
        this.target = target;
    }

    static HalFormsTemplate forMethod(HttpMethod httpMethod) {
        return new HalFormsTemplate().withHttpMethod(httpMethod);
    }

    HalFormsTemplate withTitle(String title) {
        return this.title == title ? this : new HalFormsTemplate(title, this.httpMethod, this.properties, this.contentType, this.target);
    }

    private HalFormsTemplate withHttpMethod(HttpMethod httpMethod) {
        return this.httpMethod == httpMethod ? this : new HalFormsTemplate(this.title, httpMethod, this.properties, this.contentType, this.target);
    }

    HalFormsTemplate andProperty(HalFormsProperty property) {
        Assert.notNull((Object)property, (String)"Property must not be null!");
        ArrayList<HalFormsProperty> properties = new ArrayList<HalFormsProperty>(this.properties);
        properties.add(property);
        return new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentType, this.target);
    }

    HalFormsTemplate withProperties(List<HalFormsProperty> properties) {
        return this.properties == properties ? this : new HalFormsTemplate(this.title, this.httpMethod, properties, this.contentType, this.target);
    }

    HalFormsTemplate withContentType(@Nullable MediaType contentType) {
        return this.contentType == contentType ? this : new HalFormsTemplate(this.title, this.httpMethod, this.properties, contentType, this.target);
    }

    HalFormsTemplate withTarget(String target) {
        return this.target == target ? this : new HalFormsTemplate(this.title, this.httpMethod, this.properties, this.contentType, target);
    }

    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String getContentType() {
        return this.contentType == null ? null : this.contentType.toString();
    }

    void setContentType(MediaType mediaType) {
        this.contentType = mediaType;
    }

    @Nullable
    String getMethod() {
        return this.httpMethod == null ? null : this.httpMethod.name();
    }

    void setMethod(String method) {
        this.httpMethod = HttpMethod.valueOf((String)method.toUpperCase());
    }

    Optional<HalFormsProperty> getPropertyByName(String name) {
        return this.properties.stream().filter(it -> it.getName().equals(name)).findFirst();
    }

    HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    List<HalFormsProperty> getProperties() {
        return this.properties;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String getTitle() {
        return this.title;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    String getTarget() {
        return this.target;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsTemplate)) {
            return false;
        }
        HalFormsTemplate that = (HalFormsTemplate)o;
        return Objects.equals(this.title, that.title) && this.httpMethod == that.httpMethod && Objects.equals(this.properties, that.properties) && Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.httpMethod, this.properties, this.contentType);
    }

    public String toString() {
        return "HalFormsTemplate(title=" + this.title + ", httpMethod=" + this.httpMethod + ", properties=" + this.properties + ", contentTypes=" + this.contentType + ")";
    }
}

