/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.IanaLinkRelations;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.UriTemplate;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"templated", "template"}, ignoreUnknown=true)
public class Link
implements Serializable {
    private static final long serialVersionUID = -9037755944661782121L;
    private static final Pattern URI_AND_ATTRIBUTES_PATTERN = Pattern.compile("<(.*)>;(.*)");
    public static final String ATOM_NAMESPACE = "http://www.w3.org/2005/Atom";
    @Deprecated
    public static final LinkRelation REL_SELF = IanaLinkRelations.SELF;
    @Deprecated
    public static final LinkRelation REL_FIRST = IanaLinkRelations.FIRST;
    @Deprecated
    public static final LinkRelation REL_PREVIOUS = IanaLinkRelations.PREV;
    @Deprecated
    public static final LinkRelation REL_NEXT = IanaLinkRelations.NEXT;
    @Deprecated
    public static final LinkRelation REL_LAST = IanaLinkRelations.LAST;
    private LinkRelation rel;
    private String href;
    private String hreflang;
    private String media;
    private String title;
    private String type;
    private String deprecation;
    private String profile;
    private String name;
    @JsonIgnore
    @Nullable
    private UriTemplate template;
    @JsonIgnore
    private List<Affordance> affordances;

    @Deprecated
    public Link(String href) {
        this(href, IanaLinkRelations.SELF);
    }

    @Deprecated
    public Link(String href, String rel) {
        this(href, LinkRelation.of(rel));
    }

    @Deprecated
    public Link(String href, LinkRelation rel) {
        this(href, Link.templateOrNull(href), rel, Collections.emptyList());
    }

    @Deprecated
    public Link(UriTemplate template, String rel) {
        this(template, LinkRelation.of(rel));
    }

    @Deprecated
    public Link(UriTemplate template, LinkRelation rel) {
        this(template, rel, Collections.emptyList());
    }

    private Link(UriTemplate template, LinkRelation rel, List<Affordance> affordances) {
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.notNull((Object)rel, (String)"LinkRelation must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.template = template;
        this.rel = rel;
        this.href = template.toString();
        this.affordances = affordances;
    }

    private Link(String href, @Nullable UriTemplate template, LinkRelation rel, List<Affordance> affordances) {
        Assert.hasText((String)href, (String)"Href must not be null or empty!");
        Assert.notNull((Object)rel, (String)"LinkRelation must not be null!");
        Assert.notNull(affordances, (String)"Affordances must not be null!");
        this.href = href;
        this.template = template;
        this.rel = rel;
        this.affordances = affordances;
    }

    private Link(LinkRelation rel, String href, String hreflang, String media, String title, String type, String deprecation, String profile, String name, @Nullable UriTemplate template, List<Affordance> affordances) {
        this.rel = rel;
        this.href = href;
        this.hreflang = hreflang;
        this.media = media;
        this.title = title;
        this.type = type;
        this.deprecation = deprecation;
        this.profile = profile;
        this.name = name;
        this.template = template;
        this.affordances = affordances;
    }

    public static Link of(String href) {
        return new Link(href);
    }

    public static Link of(String href, String relation) {
        return new Link(href, relation);
    }

    public static Link of(String href, LinkRelation relation) {
        return new Link(href, relation);
    }

    public static Link of(UriTemplate template, String relation) {
        return new Link(template, relation);
    }

    public static Link of(UriTemplate template, LinkRelation relation) {
        return new Link(template, relation);
    }

    protected Link() {
        this.affordances = new ArrayList<Affordance>();
    }

    public List<Affordance> getAffordances() {
        return Collections.unmodifiableList(this.affordances);
    }

    public Link withSelfRel() {
        return this.withRel(IanaLinkRelations.SELF);
    }

    public Link andAffordance(Affordance affordance) {
        Assert.notNull((Object)affordance, (String)"Affordance must not be null!");
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>(this.affordances);
        newAffordances.add(affordance);
        return this.withAffordances(newAffordances);
    }

    public Link andAffordances(List<Affordance> affordances) {
        ArrayList<Affordance> newAffordances = new ArrayList<Affordance>();
        newAffordances.addAll(this.affordances);
        newAffordances.addAll(affordances);
        return this.withAffordances(newAffordances);
    }

    public Link withAffordances(List<Affordance> affordances) {
        return new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, affordances);
    }

    @JsonIgnore
    public List<String> getVariableNames() {
        return this.template == null ? Collections.emptyList() : this.template.getVariableNames();
    }

    @JsonIgnore
    public List<TemplateVariable> getVariables() {
        return this.template == null ? Collections.emptyList() : this.template.getVariables();
    }

    public boolean isTemplated() {
        return this.template == null ? false : !this.template.getVariables().isEmpty();
    }

    public Link expand(Object ... arguments) {
        return this.template == null ? this : Link.of(this.template.expand(arguments).toString(), this.getRel());
    }

    public Link expand(Map<String, ?> arguments) {
        return this.template == null ? this : Link.of(this.template.expand(arguments).toString(), this.getRel());
    }

    public Link withRel(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"LinkRelation must not be null!");
        return new Link(relation, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withRel(String relation) {
        return this.withRel(LinkRelation.of(relation));
    }

    public boolean hasRel(String rel) {
        Assert.hasText((String)rel, (String)"Link relation must not be null or empty!");
        return this.hasRel(LinkRelation.of(rel));
    }

    public boolean hasRel(LinkRelation rel) {
        Assert.notNull((Object)rel, (String)"Link relation must not be null!");
        return this.rel.isSameAs(rel);
    }

    public URI toUri() {
        try {
            return URI.create(this.expand(new Object[0]).getHref());
        }
        catch (IllegalArgumentException o_O) {
            throw new IllegalStateException(o_O);
        }
    }

    public static Link valueOf(String element) {
        if (!StringUtils.hasText((String)element)) {
            throw new IllegalArgumentException(String.format("Given link header %s is not RFC-8288 compliant!", element));
        }
        Matcher matcher = URI_AND_ATTRIBUTES_PATTERN.matcher(element);
        if (matcher.find()) {
            Map<String, String> attributes = Link.getAttributeMap(matcher.group(2));
            if (!attributes.containsKey("rel")) {
                throw new IllegalArgumentException("Link does not provide a rel attribute!");
            }
            Link link = Link.of(matcher.group(1), attributes.get("rel"));
            if (attributes.containsKey("hreflang")) {
                link = link.withHreflang(attributes.get("hreflang"));
            }
            if (attributes.containsKey("media")) {
                link = link.withMedia(attributes.get("media"));
            }
            if (attributes.containsKey("title")) {
                link = link.withTitle(attributes.get("title"));
            }
            if (attributes.containsKey("type")) {
                link = link.withType(attributes.get("type"));
            }
            if (attributes.containsKey("deprecation")) {
                link = link.withDeprecation(attributes.get("deprecation"));
            }
            if (attributes.containsKey("profile")) {
                link = link.withProfile(attributes.get("profile"));
            }
            if (attributes.containsKey("name")) {
                link = link.withName(attributes.get("name"));
            }
            return link;
        }
        throw new IllegalArgumentException(String.format("Given link header %s is not RFC-8288 compliant!", element));
    }

    private static Map<String, String> getAttributeMap(String source) {
        if (!StringUtils.hasText((String)source)) {
            return Collections.emptyMap();
        }
        String[] parts = source.split(";");
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (String part : parts) {
            int delimiter = part.indexOf(61);
            String key = part.substring(0, delimiter).trim();
            String value = part.substring(delimiter + 1).trim();
            value = value.startsWith("\"") ? value.substring(1, value.length() - 1) : value;
            attributes.put(key, value);
        }
        return attributes;
    }

    public Link withHref(String href) {
        return this.href == href ? this : new Link(this.rel, href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withHreflang(String hreflang) {
        return this.hreflang == hreflang ? this : new Link(this.rel, this.href, hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withMedia(String media) {
        return this.media == media ? this : new Link(this.rel, this.href, this.hreflang, media, this.title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withTitle(String title) {
        return this.title == title ? this : new Link(this.rel, this.href, this.hreflang, this.media, title, this.type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withType(String type) {
        return this.type == type ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, type, this.deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withDeprecation(String deprecation) {
        return this.deprecation == deprecation ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, deprecation, this.profile, this.name, this.template, this.affordances);
    }

    public Link withProfile(String profile) {
        return this.profile == profile ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, profile, this.name, this.template, this.affordances);
    }

    public Link withName(String name) {
        return this.name == name ? this : new Link(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, name, this.template, this.affordances);
    }

    @JsonProperty
    public LinkRelation getRel() {
        return this.rel;
    }

    @JsonProperty
    public String getHref() {
        return this.href;
    }

    @JsonProperty
    public String getHreflang() {
        return this.hreflang;
    }

    @JsonProperty
    public String getMedia() {
        return this.media;
    }

    @JsonProperty
    public String getTitle() {
        return this.title;
    }

    @JsonProperty
    public String getType() {
        return this.type;
    }

    @JsonProperty
    public String getDeprecation() {
        return this.deprecation;
    }

    @JsonProperty
    public String getProfile() {
        return this.profile;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public UriTemplate getTemplate() {
        return this.template == null ? UriTemplate.of(this.href) : this.template;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.rel, link.rel) && Objects.equals(this.href, link.href) && Objects.equals(this.hreflang, link.hreflang) && Objects.equals(this.media, link.media) && Objects.equals(this.title, link.title) && Objects.equals(this.type, link.type) && Objects.equals(this.deprecation, link.deprecation) && Objects.equals(this.profile, link.profile) && Objects.equals(this.name, link.name) && Objects.equals(this.affordances, link.affordances);
    }

    public int hashCode() {
        return Objects.hash(this.rel, this.href, this.hreflang, this.media, this.title, this.type, this.deprecation, this.profile, this.name, this.affordances);
    }

    public String toString() {
        String linkString = String.format("<%s>;rel=\"%s\"", this.href, this.rel.value());
        if (this.hreflang != null) {
            linkString = linkString + ";hreflang=\"" + this.hreflang + "\"";
        }
        if (this.media != null) {
            linkString = linkString + ";media=\"" + this.media + "\"";
        }
        if (this.title != null) {
            linkString = linkString + ";title=\"" + this.title + "\"";
        }
        if (this.type != null) {
            linkString = linkString + ";type=\"" + this.type + "\"";
        }
        if (this.deprecation != null) {
            linkString = linkString + ";deprecation=\"" + this.deprecation + "\"";
        }
        if (this.profile != null) {
            linkString = linkString + ";profile=\"" + this.profile + "\"";
        }
        if (this.name != null) {
            linkString = linkString + ";name=\"" + this.name + "\"";
        }
        return linkString;
    }

    @Nullable
    private static UriTemplate templateOrNull(String href) {
        Assert.notNull((Object)href, (String)"Href must not be null!");
        return href.contains("{") ? UriTemplate.of(href) : null;
    }
}

