/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.hal.forms;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.hal.HalLinkRelation;
import org.springframework.hateoas.mediatype.hal.Jackson2HalModule;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplate;
import org.springframework.hateoas.mediatype.hal.forms.Jackson2HalFormsModule;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"attributes", "entity", "entities", "embedded", "links", "templates", "metadata"})
final class HalFormsDocument<T> {
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, Object> attributes;
    @Nullable
    @JsonUnwrapped
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final T entity;
    @Nullable
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonIgnore
    private final Collection<T> entities;
    @JsonProperty(value="_embedded")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<HalLinkRelation, Object> embedded;
    @Nullable
    @JsonProperty(value="page")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private final PagedModel.PageMetadata pageMetadata;
    @JsonProperty(value="_links")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @JsonSerialize(using=Jackson2HalModule.HalLinkListSerializer.class)
    @JsonDeserialize(using=Jackson2HalFormsModule.HalFormsLinksDeserializer.class)
    private final Links links;
    @JsonProperty(value="_templates")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private final Map<String, HalFormsTemplate> templates;

    HalFormsDocument(Map<String, Object> attributes, T entity, Collection<T> entities, Map<HalLinkRelation, Object> embedded, PagedModel.PageMetadata pageMetadata, Links links, Map<String, HalFormsTemplate> templates) {
        this.attributes = attributes;
        this.entity = entity;
        this.entities = entities;
        this.embedded = embedded;
        this.pageMetadata = pageMetadata;
        this.links = links;
        this.templates = templates;
    }

    private HalFormsDocument() {
        this(null, null, null, Collections.emptyMap(), null, Links.NONE, Collections.emptyMap());
    }

    static HalFormsDocument<?> forRepresentationModel(RepresentationModel<?> model) {
        Map<String, Object> attributes = PropertyUtils.extractPropertyValues(model);
        attributes.remove("links");
        return super.withAttributes(attributes);
    }

    static <T> HalFormsDocument<T> forEntity(@Nullable T resource) {
        return super.withEntity(resource);
    }

    static <T> HalFormsDocument<T> forEntities(Collection<T> entities) {
        Assert.notNull(entities, (String)"Resources must not be null!");
        return super.withEntities(entities);
    }

    static HalFormsDocument<?> empty() {
        return new HalFormsDocument();
    }

    private HalFormsDocument<T> withAttributes(@Nullable Map<String, Object> attributes) {
        return this.attributes == attributes ? this : new HalFormsDocument<T>(attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    private HalFormsDocument<T> withEntity(@Nullable T entity) {
        return this.entity == entity ? this : new HalFormsDocument<T>(this.attributes, entity, this.entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    private HalFormsDocument<T> withEntities(@Nullable Collection<T> entities) {
        return this.entities == entities ? this : new HalFormsDocument<T>(this.attributes, this.entity, entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    HalFormsDocument<T> andEmbedded(HalLinkRelation key, Object value) {
        Assert.notNull((Object)key, (String)"Embedded key must not be null!");
        Assert.notNull((Object)value, (String)"Embedded value must not be null!");
        HashMap<HalLinkRelation, Object> embedded = new HashMap<HalLinkRelation, Object>(this.embedded);
        embedded.put(key, value);
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, embedded, this.pageMetadata, this.links, this.templates);
    }

    HalFormsDocument<T> withEmbedded(Map<HalLinkRelation, Object> embedded) {
        return this.embedded == embedded ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, embedded, this.pageMetadata, this.links, this.templates);
    }

    HalFormsDocument<T> withPageMetadata(@Nullable PagedModel.PageMetadata pageMetadata) {
        return this.pageMetadata == pageMetadata ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, pageMetadata, this.links, this.templates);
    }

    HalFormsDocument<T> andLink(Link link) {
        Assert.notNull((Object)link, (String)"Link must not be null!");
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links.and(link), this.templates);
    }

    HalFormsDocument<T> withLinks(Links links) {
        return this.links == links ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, links, this.templates);
    }

    HalFormsDocument<T> andTemplate(String name, HalFormsTemplate template) {
        Assert.hasText((String)name, (String)"Template name must not be null or empty!");
        Assert.notNull((Object)template, (String)"Template must not be null!");
        HashMap<String, HalFormsTemplate> templates = new HashMap<String, HalFormsTemplate>(this.templates);
        templates.put(name, template);
        return new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, templates);
    }

    HalFormsDocument<T> withTemplates(Map<String, HalFormsTemplate> templates) {
        return this.templates == templates ? this : new HalFormsDocument<T>(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, templates);
    }

    @Nullable
    @JsonAnyGetter
    Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nullable
    T getEntity() {
        return this.entity;
    }

    @Nullable
    Collection<T> getEntities() {
        return this.entities;
    }

    Map<HalLinkRelation, Object> getEmbedded() {
        return this.embedded;
    }

    @Nullable
    PagedModel.PageMetadata getPageMetadata() {
        return this.pageMetadata;
    }

    Links getLinks() {
        return this.links;
    }

    Map<String, HalFormsTemplate> getTemplates() {
        return this.templates;
    }

    @JsonIgnore
    HalFormsTemplate getTemplate(String key) {
        Assert.notNull((Object)key, (String)"Template key must not be null!");
        return this.templates.get(key);
    }

    @JsonIgnore
    HalFormsTemplate getDefaultTemplate() {
        return this.getTemplate("default");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HalFormsDocument)) {
            return false;
        }
        HalFormsDocument that = (HalFormsDocument)o;
        return Objects.equals(this.attributes, that.attributes) && Objects.equals(this.entity, that.entity) && Objects.equals(this.entities, that.entities) && Objects.equals(this.embedded, that.embedded) && Objects.equals(this.pageMetadata, that.pageMetadata) && Objects.equals(this.links, that.links) && Objects.equals(this.templates, that.templates);
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.entity, this.entities, this.embedded, this.pageMetadata, this.links, this.templates);
    }

    public String toString() {
        return "HalFormsDocument(attributes=" + this.attributes + ", entity=" + this.entity + ", entities=" + this.entities + ", embedded=" + this.embedded + ", pageMetadata=" + this.pageMetadata + ", links=" + this.links + ", templates=" + this.templates + ")";
    }
}

