/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.AbstractEntityLinks;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class DelegatingEntityLinks
extends AbstractEntityLinks {
    private final PluginRegistry<EntityLinks, Class<?>> delegates;

    public DelegatingEntityLinks(PluginRegistry<EntityLinks, Class<?>> plugins) {
        Assert.notNull(plugins, (String)"PluginRegistry must not be null!");
        this.delegates = plugins;
    }

    @Override
    public LinkBuilder linkFor(Class<?> type) {
        return this.getPluginFor(type).linkFor(type);
    }

    @Override
    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.getPluginFor(type).linkFor(type, parameters);
    }

    @Override
    public Link linkToCollectionResource(Class<?> type) {
        return this.getPluginFor(type).linkToCollectionResource(type);
    }

    @Override
    public Link linkToItemResource(Class<?> type, Object id) {
        return this.getPluginFor(type).linkToItemResource(type, id);
    }

    @Override
    public LinkBuilder linkForItemResource(Class<?> type, Object id) {
        return this.getPluginFor(type).linkForItemResource(type, id);
    }

    public boolean supports(Class<?> delimiter) {
        return this.delegates.hasPluginFor(delimiter);
    }

    private EntityLinks getPluginFor(Class<?> type) {
        return (EntityLinks)this.delegates.getPluginFor(type).orElseThrow(() -> new IllegalArgumentException(String.format("Cannot determine link for %s! No EntityLinks instance found supporting the domain type!", type.getName())));
    }
}

