/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.context.annotation.Configuration;
import org.springframework.hateoas.config.HypermediaMappingInformation;
import org.springframework.http.codec.ClientCodecConfigurer;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.http.codec.json.AbstractJackson2Decoder;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.util.Assert;
import org.springframework.util.MimeType;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;

@Configuration
public class WebClientConfigurer {
    Consumer<ClientCodecConfigurer> configurer;

    public WebClientConfigurer(ObjectMapper mapper, List<HypermediaMappingInformation> hypermediaTypes) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull(hypermediaTypes, (String)"HypermediaMappingInformations must not be null!");
        ArrayList encoders = new ArrayList();
        ArrayList decoders = new ArrayList();
        hypermediaTypes.forEach(hypermedia -> {
            ObjectMapper objectMapper = hypermedia.configureObjectMapper(mapper.copy());
            MimeType[] mimeTypes = hypermedia.getMediaTypes().toArray(new MimeType[0]);
            encoders.add(new Jackson2JsonEncoder(objectMapper, mimeTypes));
            decoders.add(new Jackson2JsonDecoder(objectMapper, mimeTypes));
        });
        this.configurer = it -> {
            CodecConfigurer.CustomCodecs codecs = it.customCodecs();
            encoders.forEach(arg_0 -> ((CodecConfigurer.CustomCodecs)codecs).encoder(arg_0));
            decoders.stream().peek(WebClientConfigurer.applyDefaultConfiguration(codecs)).forEach(arg_0 -> ((CodecConfigurer.CustomCodecs)codecs).decoder(arg_0));
        };
    }

    public ExchangeStrategies hypermediaExchangeStrategies() {
        return ExchangeStrategies.builder().codecs(this.configurer).build();
    }

    public WebClient registerHypermediaTypes(WebClient webClient) {
        return webClient.mutate().exchangeStrategies(it -> it.codecs(this.configurer)).build();
    }

    private static Consumer<AbstractJackson2Decoder> applyDefaultConfiguration(CodecConfigurer.CustomCodecs codecs) {
        return decoder -> codecs.withDefaultCodecConfig(config -> {
            Integer maxInMemorySize = config.maxInMemorySize();
            if (maxInMemorySize != null) {
                decoder.setMaxInMemorySize(maxInMemorySize.intValue());
            }
        });
    }
}

