/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public final class IanaLinkRelations {
    public static final LinkRelation ABOUT = LinkRelation.of("about");
    public static final LinkRelation ALTERNATE = LinkRelation.of("alternate");
    public static final LinkRelation APPENDIX = LinkRelation.of("appendix");
    public static final LinkRelation ARCHIVES = LinkRelation.of("archives");
    public static final LinkRelation AUTHOR = LinkRelation.of("author");
    public static final LinkRelation BLOCKED_BY = LinkRelation.of("blocked-by");
    public static final LinkRelation BOOKMARK = LinkRelation.of("bookmark");
    public static final LinkRelation CANONICAL = LinkRelation.of("canonical");
    public static final LinkRelation CHAPTER = LinkRelation.of("chapter");
    public static final LinkRelation CITE_AS = LinkRelation.of("cite-as");
    public static final LinkRelation COLLECTION = LinkRelation.of("collection");
    public static final LinkRelation CONTENTS = LinkRelation.of("contents");
    public static final LinkRelation CONVERTED_FROM = LinkRelation.of("convertedFrom");
    public static final LinkRelation COPYRIGHT = LinkRelation.of("copyright");
    public static final LinkRelation CREATE_FORM = LinkRelation.of("create-form");
    public static final LinkRelation CURRENT = LinkRelation.of("current");
    public static final LinkRelation DESCRIBED_BY = LinkRelation.of("describedBy");
    public static final LinkRelation DESCRIBES = LinkRelation.of("describes");
    public static final LinkRelation DISCLOSURE = LinkRelation.of("disclosure");
    public static final LinkRelation DNS_PREFETCH = LinkRelation.of("dns-prefetch");
    public static final LinkRelation DUPLICATE = LinkRelation.of("duplicate");
    public static final LinkRelation EDIT = LinkRelation.of("edit");
    public static final LinkRelation EDIT_FORM = LinkRelation.of("edit-form");
    public static final LinkRelation EDIT_MEDIA = LinkRelation.of("edit-media");
    public static final LinkRelation ENCLOSURE = LinkRelation.of("enclosure");
    public static final LinkRelation FIRST = LinkRelation.of("first");
    public static final LinkRelation GLOSSARY = LinkRelation.of("glossary");
    public static final LinkRelation HELP = LinkRelation.of("help");
    public static final LinkRelation HOSTS = LinkRelation.of("hosts");
    public static final LinkRelation HUB = LinkRelation.of("hub");
    public static final LinkRelation ICON = LinkRelation.of("icon");
    public static final LinkRelation INDEX = LinkRelation.of("index");
    public static final LinkRelation INTERVAL_AFTER = LinkRelation.of("intervalAfter");
    public static final LinkRelation INTERVAL_BEFORE = LinkRelation.of("intervalBefore");
    public static final LinkRelation INTERVAL_CONTAINS = LinkRelation.of("intervalContains");
    public static final LinkRelation INTERVAL_DISJOINT = LinkRelation.of("intervalDisjoint");
    public static final LinkRelation INTERVAL_DURING = LinkRelation.of("intervalDuring");
    public static final LinkRelation INTERVAL_EQUALS = LinkRelation.of("intervalEquals");
    public static final LinkRelation INTERVAL_FINISHED_BY = LinkRelation.of("intervalFinishedBy");
    public static final LinkRelation INTERVAL_FINISHES = LinkRelation.of("intervalFinishes");
    public static final LinkRelation INTERVAL_IN = LinkRelation.of("intervalIn");
    public static final LinkRelation INTERVAL_MEETS = LinkRelation.of("intervalMeets");
    public static final LinkRelation INTERVAL_MET_BY = LinkRelation.of("intervalMetBy");
    public static final LinkRelation INTERVAL_OVERLAPPED_BY = LinkRelation.of("intervalOverlappedBy");
    public static final LinkRelation INTERVAL_OVERLAPS = LinkRelation.of("intervalOverlaps");
    public static final LinkRelation INTERVAL_STARTED_BY = LinkRelation.of("intervalStartedBy");
    public static final LinkRelation INTERVAL_STARTS = LinkRelation.of("intervalStarts");
    public static final LinkRelation ITEM = LinkRelation.of("item");
    public static final LinkRelation LAST = LinkRelation.of("last");
    public static final LinkRelation LATEST_VERSION = LinkRelation.of("latest-version");
    public static final LinkRelation LICENSE = LinkRelation.of("license");
    public static final LinkRelation LRDD = LinkRelation.of("lrdd");
    public static final LinkRelation MEMENTO = LinkRelation.of("memento");
    public static final LinkRelation MONITOR = LinkRelation.of("monitor");
    public static final LinkRelation MONITOR_GROUP = LinkRelation.of("monitor-group");
    public static final LinkRelation NEXT = LinkRelation.of("next");
    public static final LinkRelation NEXT_ARCHIVE = LinkRelation.of("next-archive");
    public static final LinkRelation NOFOLLOW = LinkRelation.of("nofollow");
    public static final LinkRelation NOREFERRER = LinkRelation.of("noreferrer");
    public static final LinkRelation ORIGINAL = LinkRelation.of("original");
    public static final LinkRelation PAYMENT = LinkRelation.of("payment");
    public static final LinkRelation PINGBACK = LinkRelation.of("pingback");
    public static final LinkRelation PRECONNECT = LinkRelation.of("preconnect");
    public static final LinkRelation PREDECESSOR_VERSION = LinkRelation.of("predecessor-version");
    public static final LinkRelation PREFETCH = LinkRelation.of("prefetch");
    public static final LinkRelation PRELOAD = LinkRelation.of("preload");
    public static final LinkRelation PRERENDER = LinkRelation.of("prerender");
    public static final LinkRelation PREV = LinkRelation.of("prev");
    public static final LinkRelation PREVIEW = LinkRelation.of("preview");
    public static final LinkRelation PREVIOUS = LinkRelation.of("previous");
    public static final LinkRelation PREV_ARCHIVE = LinkRelation.of("prev-archive");
    public static final LinkRelation PRIVACY_POLICY = LinkRelation.of("privacy-policy");
    public static final LinkRelation PROFILE = LinkRelation.of("profile");
    public static final LinkRelation RELATED = LinkRelation.of("related");
    public static final LinkRelation RESTCONF = LinkRelation.of("restconf");
    public static final LinkRelation REPLIES = LinkRelation.of("replies");
    public static final LinkRelation SEARCH = LinkRelation.of("search");
    public static final LinkRelation SECTION = LinkRelation.of("section");
    public static final LinkRelation SELF = LinkRelation.of("self");
    public static final LinkRelation SERVICE = LinkRelation.of("service");
    public static final LinkRelation START = LinkRelation.of("start");
    public static final LinkRelation STYLESHEET = LinkRelation.of("stylesheet");
    public static final LinkRelation SUBSECTION = LinkRelation.of("subsection");
    public static final LinkRelation SUCCESSOR_VERSION = LinkRelation.of("successor-versions");
    public static final LinkRelation TAG = LinkRelation.of("tag");
    public static final LinkRelation TERMS_OF_SERVICE = LinkRelation.of("terms-of-service");
    public static final LinkRelation TIMEGATE = LinkRelation.of("timegate");
    public static final LinkRelation TIMEMAP = LinkRelation.of("timemap");
    public static final LinkRelation TYPE = LinkRelation.of("type");
    public static final LinkRelation UP = LinkRelation.of("up");
    public static final LinkRelation VERSION_HISTORY = LinkRelation.of("version-history");
    public static final LinkRelation VIA = LinkRelation.of("via");
    public static final LinkRelation WEBMENTION = LinkRelation.of("webmention");
    public static final LinkRelation WORKING_COPY = LinkRelation.of("working-copy");
    public static final LinkRelation WORKING_COPY_OF = LinkRelation.of("working-copy-of");
    private static final Set<LinkRelation> LINK_RELATIONS = Arrays.stream(IanaLinkRelations.class.getDeclaredFields()).filter(ReflectionUtils::isPublicStaticFinal).map(it -> ReflectionUtils.getField((Field)it, null)).map(LinkRelation.class::cast).collect(Collectors.toSet());

    public static boolean isIanaRel(String relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return LINK_RELATIONS.stream().anyMatch(it -> it.value().equalsIgnoreCase(relation));
    }

    public static boolean isIanaRel(LinkRelation relation) {
        Assert.notNull((Object)relation, (String)"Link relation must not be null!");
        return LINK_RELATIONS.contains(relation) || LINK_RELATIONS.stream().anyMatch(it -> it.isSameAs(relation));
    }

    public static LinkRelation parse(String relation) {
        return LINK_RELATIONS.stream().filter(it -> it.value().equalsIgnoreCase(relation)).findFirst().orElseThrow(() -> new IllegalArgumentException(relation + " is not a valid IANA link relation!"));
    }

    @Generated
    private IanaLinkRelations() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

