/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class CollectionModel<T>
extends RepresentationModel<CollectionModel<T>>
implements Iterable<T> {
    private final Collection<T> content;

    protected CollectionModel() {
        this(new ArrayList(), new Link[0]);
    }

    @Deprecated
    public CollectionModel(Iterable<T> content, Link ... links) {
        this(content, Arrays.asList(links));
    }

    @Deprecated
    public CollectionModel(Iterable<T> content, Iterable<Link> links) {
        Assert.notNull(content, (String)"Content must not be null!");
        this.content = new ArrayList<T>();
        for (T element : content) {
            this.content.add(element);
        }
        this.add(links);
    }

    public static <T> CollectionModel<T> empty() {
        return CollectionModel.of(Collections.emptyList());
    }

    public static <T> CollectionModel<T> of(Iterable<T> content) {
        return CollectionModel.of(content, Collections.emptyList());
    }

    public static <T> CollectionModel<T> of(Iterable<T> content, Link ... links) {
        return CollectionModel.of(content, Arrays.asList(links));
    }

    public static <T> CollectionModel<T> of(Iterable<T> content, Iterable<Link> links) {
        return new CollectionModel<T>(content, links);
    }

    public static <T extends EntityModel<S>, S> CollectionModel<T> wrap(Iterable<S> content) {
        Assert.notNull(content, (String)"Content must not be null!");
        ArrayList<EntityModel<S>> resources = new ArrayList<EntityModel<S>>();
        for (S element : content) {
            resources.add(EntityModel.of(element));
        }
        return CollectionModel.of(resources);
    }

    @JsonProperty(value="content")
    public Collection<T> getContent() {
        return Collections.unmodifiableCollection(this.content);
    }

    @Override
    public Iterator<T> iterator() {
        return this.content.iterator();
    }

    @Override
    public String toString() {
        return String.format("Resources { content: %s, %s }", this.getContent(), super.toString());
    }

    @Override
    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        CollectionModel that = (CollectionModel)obj;
        boolean contentEqual = this.content == null ? that.content == null : this.content.equals(that.content);
        return contentEqual && super.equals(obj);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result += this.content == null ? 0 : 17 * this.content.hashCode();
    }
}

