/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.TemplateVariable;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.core.AnnotationAttribute;
import org.springframework.hateoas.server.core.AnnotationMappingDiscoverer;
import org.springframework.hateoas.server.core.CachingMappingDiscoverer;
import org.springframework.hateoas.server.core.EncodingUtils;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.hateoas.server.core.MethodParameters;
import org.springframework.hateoas.server.core.SpringAffordanceBuilder;
import org.springframework.hateoas.server.core.UriTemplateFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import org.springframework.web.util.UriTemplate;

public class WebHandler {
    private static final MappingDiscoverer DISCOVERER = CachingMappingDiscoverer.of(new AnnotationMappingDiscoverer(RequestMapping.class));
    private static final AnnotatedParametersParameterAccessor PATH_VARIABLE_ACCESSOR = new AnnotatedParametersParameterAccessor(new AnnotationAttribute(PathVariable.class));
    private static final AnnotatedParametersParameterAccessor REQUEST_PARAM_ACCESSOR = new RequestParamParameterAccessor();
    private static final Map<AffordanceKey, List<Affordance>> AFFORDANCES_CACHE = new ConcurrentReferenceHashMap();

    public static <T extends LinkBuilder> Function<Function<String, UriComponentsBuilder>, T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator) {
        return WebHandler.linkTo(invocationValue, creator, null);
    }

    public static <T extends LinkBuilder> Function<Function<String, UriComponentsBuilder>, T> linkTo(Object invocationValue, LinkBuilderCreator<T> creator, @Nullable BiFunction<UriComponentsBuilder, MethodInvocation, UriComponentsBuilder> additionalUriHandler) {
        Assert.isInstanceOf(LastInvocationAware.class, (Object)invocationValue);
        LastInvocationAware invocations = (LastInvocationAware)invocationValue;
        MethodInvocation invocation = invocations.getLastInvocation();
        return mappingToUriComponentsBuilder -> {
            String mapping = DISCOVERER.getMapping(invocation.getTargetType(), invocation.getMethod());
            UriComponentsBuilder builder = (UriComponentsBuilder)mappingToUriComponentsBuilder.apply(mapping);
            UriTemplate template = UriTemplateFactory.templateFor(mapping == null ? "/" : mapping);
            HashMap<Object, Object> values = new HashMap<Object, Object>();
            Iterator names = template.getVariableNames().iterator();
            Iterator<Object> classMappingParameters = invocations.getObjectParameters();
            while (classMappingParameters.hasNext()) {
                values.put(names.next(), EncodingUtils.encodePath(classMappingParameters.next()));
            }
            for (AnnotatedParametersParameterAccessor.BoundMethodParameter boundMethodParameter : PATH_VARIABLE_ACCESSOR.getBoundParameters(invocation)) {
                values.put(boundMethodParameter.getVariableName(), EncodingUtils.encodePath(boundMethodParameter.asString()));
            }
            ArrayList<String> optionalEmptyParameters = new ArrayList<String>();
            for (AnnotatedParametersParameterAccessor.BoundMethodParameter parameter : REQUEST_PARAM_ACCESSOR.getBoundParameters(invocation)) {
                WebHandler.bindRequestParameters(builder, parameter);
                if (!UriComponents.UriTemplateVariables.SKIP_VALUE.equals(parameter.getValue())) continue;
                values.put(parameter.getVariableName(), UriComponents.UriTemplateVariables.SKIP_VALUE);
                if (parameter.isRequired()) continue;
                optionalEmptyParameters.add(parameter.getVariableName());
            }
            for (String variable : template.getVariableNames()) {
                if (values.containsKey(variable)) continue;
                values.put(variable, UriComponents.UriTemplateVariables.SKIP_VALUE);
            }
            UriComponents uriComponents = additionalUriHandler == null ? builder.buildAndExpand(values) : ((UriComponentsBuilder)additionalUriHandler.apply(builder, invocation)).buildAndExpand(values);
            TemplateVariables variables = TemplateVariables.NONE;
            for (String parameter : optionalEmptyParameters) {
                boolean previousRequestParameter = uriComponents.getQueryParams().isEmpty() && variables.equals(TemplateVariables.NONE);
                TemplateVariable variable = new TemplateVariable(parameter, previousRequestParameter ? TemplateVariable.VariableType.REQUEST_PARAM : TemplateVariable.VariableType.REQUEST_PARAM_CONTINUED);
                variables = variables.concat(variable);
            }
            String href = uriComponents.toUriString().equals("") ? "/" : uriComponents.toUriString();
            List affordances = AFFORDANCES_CACHE.computeIfAbsent(AffordanceKey.of(invocation.getTargetType(), invocation.getMethod(), href), key -> SpringAffordanceBuilder.create(((AffordanceKey)key).type, ((AffordanceKey)key).method, ((AffordanceKey)key).href, DISCOVERER));
            return creator.createBuilder(uriComponents, variables, affordances);
        };
    }

    private static void bindRequestParameters(UriComponentsBuilder builder, AnnotatedParametersParameterAccessor.BoundMethodParameter parameter) {
        Object value = parameter.getValue();
        String key = parameter.getVariableName();
        if (value instanceof MultiValueMap) {
            MultiValueMap requestParams = (MultiValueMap)value;
            for (Map.Entry multiValueEntry : requestParams.entrySet()) {
                for (String singleEntryValue : (List)multiValueEntry.getValue()) {
                    builder.queryParam((String)multiValueEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(singleEntryValue)});
                }
            }
        } else if (value instanceof Map) {
            Map requestParams = (Map)value;
            for (Map.Entry requestParamEntry : requestParams.entrySet()) {
                builder.queryParam((String)requestParamEntry.getKey(), new Object[]{EncodingUtils.encodeParameter(requestParamEntry.getValue())});
            }
        } else if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                if (key == null) continue;
                builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(element)});
            }
        } else if (UriComponents.UriTemplateVariables.SKIP_VALUE.equals(value)) {
            if (parameter.isRequired() && key != null) {
                builder.queryParam(key, new Object[]{String.format("{%s}", parameter.getVariableName())});
            }
        } else if (key != null) {
            builder.queryParam(key, new Object[]{EncodingUtils.encodeParameter(parameter.asString())});
        }
    }

    private static final class AffordanceKey {
        private final Class<?> type;
        private final Method method;
        private final String href;

        @Generated
        private AffordanceKey(Class<?> type, Method method, String href) {
            this.type = type;
            this.method = method;
            this.href = href;
        }

        @Generated
        public static AffordanceKey of(Class<?> type, Method method, String href) {
            return new AffordanceKey(type, method, href);
        }

        @Generated
        public Class<?> getType() {
            return this.type;
        }

        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Generated
        public String getHref() {
            return this.href;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AffordanceKey)) {
                return false;
            }
            AffordanceKey other = (AffordanceKey)o;
            Class<?> this$type = this.getType();
            Class<?> other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            String this$href = this.getHref();
            String other$href = other.getHref();
            return !(this$href == null ? other$href != null : !this$href.equals(other$href));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            String $href = this.getHref();
            result = result * 59 + ($href == null ? 43 : $href.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "WebHandler.AffordanceKey(type=" + this.getType() + ", method=" + this.getMethod() + ", href=" + this.getHref() + ")";
        }
    }

    private static class AnnotatedParametersParameterAccessor {
        @NonNull
        private final AnnotationAttribute attribute;

        public List<BoundMethodParameter> getBoundParameters(MethodInvocation invocation) {
            Assert.notNull((Object)invocation, (String)"MethodInvocation must not be null!");
            MethodParameters parameters = MethodParameters.of(invocation.getMethod());
            Object[] arguments = invocation.getArguments();
            ArrayList<BoundMethodParameter> result = new ArrayList<BoundMethodParameter>();
            for (MethodParameter parameter : parameters.getParametersWith(this.attribute.getAnnotationType())) {
                Object value;
                Object verifiedValue = this.verifyParameterValue(parameter, value = arguments[parameter.getParameterIndex()]);
                if (verifiedValue == null) continue;
                result.add(this.createParameter(parameter, verifiedValue, this.attribute));
            }
            return result;
        }

        protected BoundMethodParameter createParameter(MethodParameter parameter, @Nullable Object value, AnnotationAttribute attribute) {
            return new BoundMethodParameter(parameter, value, attribute);
        }

        @Nullable
        protected Object verifyParameterValue(MethodParameter parameter, @Nullable Object value) {
            return value;
        }

        @Generated
        public AnnotatedParametersParameterAccessor(@NonNull AnnotationAttribute attribute) {
            if (attribute == null) {
                throw new IllegalArgumentException("attribute is marked @NonNull but is null");
            }
            this.attribute = attribute;
        }

        static class BoundMethodParameter {
            private static final ConversionService CONVERSION_SERVICE = new DefaultFormattingConversionService();
            private static final TypeDescriptor STRING_DESCRIPTOR = TypeDescriptor.valueOf(String.class);
            private final MethodParameter parameter;
            private final Object value;
            private final AnnotationAttribute attribute;
            private final TypeDescriptor parameterTypeDescriptor;

            public BoundMethodParameter(MethodParameter parameter, @Nullable Object value, AnnotationAttribute attribute) {
                Assert.notNull((Object)parameter, (String)"MethodParameter must not be null!");
                boolean isOptionalWrapper = Optional.class.isAssignableFrom(parameter.getParameterType());
                this.parameter = parameter;
                this.value = value;
                this.attribute = attribute;
                this.parameterTypeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)(isOptionalWrapper ? 1 : 0));
            }

            @Nullable
            public String getVariableName() {
                if (this.attribute == null) {
                    return this.parameter.getParameterName();
                }
                Annotation annotation = this.parameter.getParameterAnnotation(this.attribute.getAnnotationType());
                String annotationAttributeValue = annotation != null ? this.attribute.getValueFrom(annotation) : "";
                return StringUtils.hasText((String)annotationAttributeValue) ? annotationAttributeValue : this.parameter.getParameterName();
            }

            @Nullable
            public Object getValue() {
                return this.value;
            }

            public String asString() {
                Object value = this.value;
                if (value == null) {
                    throw new IllegalStateException("Cannot turn null value into required String!");
                }
                Object result = CONVERSION_SERVICE.convert(value, this.parameterTypeDescriptor, STRING_DESCRIPTOR);
                if (result == null) {
                    throw new IllegalStateException(String.format("Conversion of value %s resulted in null!", value));
                }
                return (String)result;
            }

            public boolean isRequired() {
                return true;
            }
        }
    }

    private static class RequestParamParameterAccessor
    extends AnnotatedParametersParameterAccessor {
        public RequestParamParameterAccessor() {
            super(new AnnotationAttribute(RequestParam.class));
        }

        @Override
        protected AnnotatedParametersParameterAccessor.BoundMethodParameter createParameter(final MethodParameter parameter, @Nullable Object value, AnnotationAttribute attribute) {
            return new AnnotatedParametersParameterAccessor.BoundMethodParameter(parameter, value, attribute){

                @Override
                public boolean isRequired() {
                    RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
                    if (parameter.isOptional()) {
                        return false;
                    }
                    return annotation != null && annotation.required() && annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n");
                }
            };
        }

        @Override
        @Nullable
        protected Object verifyParameterValue(MethodParameter parameter, @Nullable Object value) {
            RequestParam annotation = (RequestParam)parameter.getParameterAnnotation(RequestParam.class);
            if ((value = ObjectUtils.unwrapOptional((Object)value)) != null) {
                return value;
            }
            if (annotation == null || !annotation.required() || parameter.isOptional()) {
                return UriComponents.UriTemplateVariables.SKIP_VALUE;
            }
            return annotation.defaultValue().equals("\n\t\t\n\t\t\n\ue000\ue001\ue002\n\t\t\t\t\n") ? UriComponents.UriTemplateVariables.SKIP_VALUE : null;
        }
    }

    public static interface LinkBuilderCreator<T extends LinkBuilder> {
        public T createBuilder(UriComponents var1, TemplateVariables var2, List<Affordance> var3);
    }
}

