/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.core.HeaderLinksResponseEntity;
import org.springframework.hateoas.server.mvc.RepresentationModelProcessorInvoker;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepresentationModelProcessorHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    static final ResolvableType RESOURCE_TYPE = ResolvableType.forRawClass(EntityModel.class);
    static final ResolvableType RESOURCES_TYPE = ResolvableType.forRawClass(CollectionModel.class);
    private static final ResolvableType HTTP_ENTITY_TYPE = ResolvableType.forRawClass(HttpEntity.class);
    static final Field CONTENT_FIELD = ReflectionUtils.findField(CollectionModel.class, (String)"content");
    @NonNull
    private final HandlerMethodReturnValueHandler delegate;
    @NonNull
    private final RepresentationModelProcessorInvoker invoker;
    private boolean rootLinksAsHeaders = false;

    public void setRootLinksAsHeaders(boolean rootLinksAsHeaders) {
        this.rootLinksAsHeaders = rootLinksAsHeaders;
    }

    public boolean supportsReturnType(MethodParameter returnType) {
        return this.delegate.supportsReturnType(returnType);
    }

    public void handleReturnValue(Object returnValue, MethodParameter returnType, ModelAndViewContainer mavContainer, NativeWebRequest webRequest) throws Exception {
        Object value = returnValue;
        if (returnValue instanceof HttpEntity) {
            value = ((HttpEntity)returnValue).getBody();
        }
        if (!(value instanceof RepresentationModel)) {
            this.delegate.handleReturnValue(returnValue, returnType, mavContainer, webRequest);
            return;
        }
        ResolvableType targetType = ResolvableType.forMethodReturnType((Method)returnType.getMethod());
        if (HTTP_ENTITY_TYPE.isAssignableFrom(targetType)) {
            targetType = targetType.getGeneric(new int[]{0});
        }
        ResolvableType returnValueType = ResolvableType.forClass(value.getClass());
        if (!RepresentationModelProcessorHandlerMethodReturnValueHandler.getRawType(targetType).equals(RepresentationModelProcessorHandlerMethodReturnValueHandler.getRawType(returnValueType))) {
            targetType = returnValueType;
        }
        RepresentationModel result = this.invoker.invokeProcessorsFor((RepresentationModel)value, targetType);
        this.delegate.handleReturnValue(this.rewrapResult(result, returnValue), returnType, mavContainer, webRequest);
    }

    Object rewrapResult(RepresentationModel<?> newBody, Object originalValue) {
        if (!(originalValue instanceof HttpEntity)) {
            return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(newBody) : newBody;
        }
        HttpEntity entity = null;
        if (originalValue instanceof ResponseEntity) {
            ResponseEntity source = (ResponseEntity)originalValue;
            entity = new ResponseEntity(newBody, (MultiValueMap)source.getHeaders(), source.getStatusCode());
        } else {
            HttpEntity source = (HttpEntity)originalValue;
            entity = new HttpEntity(newBody, (MultiValueMap)source.getHeaders());
        }
        return this.rootLinksAsHeaders ? HeaderLinksResponseEntity.wrap(entity) : entity;
    }

    private static Class<?> getRawType(ResolvableType type) {
        Class rawType = type.getRawClass();
        return rawType == null ? Object.class : rawType;
    }

    @Generated
    public RepresentationModelProcessorHandlerMethodReturnValueHandler(@NonNull HandlerMethodReturnValueHandler delegate, @NonNull RepresentationModelProcessorInvoker invoker) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is marked @NonNull but is null");
        }
        if (invoker == null) {
            throw new IllegalArgumentException("invoker is marked @NonNull but is null");
        }
        this.delegate = delegate;
        this.invoker = invoker;
    }

    static {
        ReflectionUtils.makeAccessible((Field)CONTENT_FIELD);
    }
}

