/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.mvc;

import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.ExposesResourceFor;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.util.Assert;

public class ControllerLinkRelationProvider
implements LinkRelationProvider {
    private final Class<?> controllerType;
    private final Class<?> entityType;
    private final PluginRegistry<LinkRelationProvider, Class<?>> providers;

    public ControllerLinkRelationProvider(Class<?> controller, PluginRegistry<LinkRelationProvider, Class<?>> providers) {
        Assert.notNull(controller, (String)"Controller must not be null!");
        ExposesResourceFor annotation = (ExposesResourceFor)AnnotationUtils.findAnnotation(controller, ExposesResourceFor.class);
        Assert.notNull((Object)annotation, (String)"Controller must be annotated with ExposesResourceFor!");
        this.controllerType = controller;
        this.entityType = annotation.value();
        this.providers = providers;
    }

    @Override
    public LinkRelation getItemResourceRelFor(Class<?> resource) {
        return ((LinkRelationProvider)this.providers.getRequiredPluginFor(this.entityType)).getItemResourceRelFor(resource);
    }

    @Override
    public LinkRelation getCollectionResourceRelFor(Class<?> resource) {
        return ((LinkRelationProvider)this.providers.getRequiredPluginFor(this.entityType)).getCollectionResourceRelFor(resource);
    }

    public boolean supports(Class<?> delimiter) {
        return this.controllerType.equals(delimiter);
    }
}

