/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import lombok.NonNull;
import org.aopalliance.aop.Advice;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.cglib.proxy.Enhancer;
import org.springframework.cglib.proxy.MethodInterceptor;
import org.springframework.hateoas.server.core.LastInvocationAware;
import org.springframework.hateoas.server.core.MethodInvocation;
import org.springframework.objenesis.ObjenesisStd;
import org.springframework.util.Assert;
import org.springframework.util.ConcurrentReferenceHashMap;
import org.springframework.util.ReflectionUtils;

public class DummyInvocationUtils {
    private static final ObjenesisStd OBJENESIS = new ObjenesisStd();
    private static final Map<Class<?>, Class<?>> CLASS_CACHE = new ConcurrentReferenceHashMap(16, ConcurrentReferenceHashMap.ReferenceType.WEAK);

    public static <T> T methodOn(Class<T> type, Object ... parameters) {
        Assert.notNull(type, (String)"Given type must not be null!");
        InvocationRecordingMethodInterceptor interceptor = new InvocationRecordingMethodInterceptor(type, parameters);
        return DummyInvocationUtils.getProxyWithInterceptor(type, interceptor, type.getClassLoader());
    }

    private static <T> T getProxyWithInterceptor(Class<?> type, InvocationRecordingMethodInterceptor interceptor, ClassLoader classLoader) {
        ProxyFactory factory = new ProxyFactory();
        factory.addAdvice((Advice)interceptor);
        factory.addInterface(LastInvocationAware.class);
        if (type.isInterface()) {
            factory.addInterface(type);
        } else {
            factory.setTargetClass(type);
            factory.setProxyTargetClass(true);
        }
        return (T)factory.getProxy(classLoader);
    }

    private static Class<?> getOrCreateEnhancedClass(Class<?> type, ClassLoader classLoader) {
        Assert.notNull(type, (String)"Source type must not be null!");
        Assert.notNull((Object)classLoader, (String)"ClassLoader must not be null!");
        return CLASS_CACHE.computeIfAbsent(type, key -> {
            Enhancer enhancer = new Enhancer();
            enhancer.setSuperclass(key);
            enhancer.setInterfaces(new Class[]{LastInvocationAware.class});
            enhancer.setCallbackType(MethodInterceptor.class);
            enhancer.setClassLoader(classLoader);
            return enhancer.createClass();
        });
    }

    private static final class SimpleMethodInvocation
    implements MethodInvocation {
        @NonNull
        private final Class<?> targetType;
        @NonNull
        private final Method method;
        @NonNull
        private final Object[] arguments;

        @Generated
        public SimpleMethodInvocation(@NonNull Class<?> targetType, @NonNull Method method, @NonNull Object[] arguments) {
            if (targetType == null) {
                throw new IllegalArgumentException("targetType is marked @NonNull but is null");
            }
            if (method == null) {
                throw new IllegalArgumentException("method is marked @NonNull but is null");
            }
            if (arguments == null) {
                throw new IllegalArgumentException("arguments is marked @NonNull but is null");
            }
            this.targetType = targetType;
            this.method = method;
            this.arguments = arguments;
        }

        @Override
        @NonNull
        @Generated
        public Class<?> getTargetType() {
            return this.targetType;
        }

        @Override
        @NonNull
        @Generated
        public Method getMethod() {
            return this.method;
        }

        @Override
        @NonNull
        @Generated
        public Object[] getArguments() {
            return this.arguments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SimpleMethodInvocation)) {
                return false;
            }
            SimpleMethodInvocation other = (SimpleMethodInvocation)o;
            Class<?> this$targetType = this.getTargetType();
            Class<?> other$targetType = other.getTargetType();
            if (this$targetType == null ? other$targetType != null : !this$targetType.equals(other$targetType)) {
                return false;
            }
            Method this$method = this.getMethod();
            Method other$method = other.getMethod();
            if (this$method == null ? other$method != null : !((Object)this$method).equals(other$method)) {
                return false;
            }
            return Arrays.deepEquals(this.getArguments(), other.getArguments());
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<?> $targetType = this.getTargetType();
            result = result * 59 + ($targetType == null ? 43 : $targetType.hashCode());
            Method $method = this.getMethod();
            result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
            result = result * 59 + Arrays.deepHashCode(this.getArguments());
            return result;
        }

        @Generated
        public String toString() {
            return "DummyInvocationUtils.SimpleMethodInvocation(targetType=" + this.getTargetType() + ", method=" + this.getMethod() + ", arguments=" + Arrays.deepToString(this.getArguments()) + ")";
        }
    }

    private static class InvocationRecordingMethodInterceptor
    implements org.aopalliance.intercept.MethodInterceptor,
    LastInvocationAware {
        private static final Method GET_INVOCATIONS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getLastInvocation");
        private static final Method GET_OBJECT_PARAMETERS = ReflectionUtils.findMethod(LastInvocationAware.class, (String)"getObjectParameters");
        private final Class<?> targetType;
        private final Object[] objectParameters;
        private MethodInvocation invocation;

        InvocationRecordingMethodInterceptor(Class<?> targetType, Object ... parameters) {
            Assert.notNull(targetType, (String)"Target type must not be null!");
            Assert.notNull((Object)parameters, (String)"Parameters must not be null!");
            this.targetType = targetType;
            this.objectParameters = (Object[])parameters.clone();
        }

        public Object invoke(org.aopalliance.intercept.MethodInvocation invocation) {
            Method method = invocation.getMethod();
            if (GET_INVOCATIONS.equals(method)) {
                return this.getLastInvocation();
            }
            if (GET_OBJECT_PARAMETERS.equals(method)) {
                return this.getObjectParameters();
            }
            if (ReflectionUtils.isObjectMethod((Method)method)) {
                return ReflectionUtils.invokeMethod((Method)method, (Object)invocation.getThis(), (Object[])invocation.getArguments());
            }
            this.invocation = new SimpleMethodInvocation(this.targetType, method, invocation.getArguments());
            Class<?> returnType = method.getReturnType();
            ClassLoader classLoader = method.getDeclaringClass().getClassLoader();
            return returnType.cast(DummyInvocationUtils.getProxyWithInterceptor(returnType, this, classLoader));
        }

        @Override
        public MethodInvocation getLastInvocation() {
            return this.invocation;
        }

        @Override
        public Iterator<Object> getObjectParameters() {
            return Arrays.asList(this.objectParameters).iterator();
        }
    }
}

