/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.reflect.AnnotatedElement;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.Relation;

public class AnnotationLinkRelationProvider
implements LinkRelationProvider,
Ordered {
    private final Map<Class<?>, Relation> annotationCache = new HashMap();

    @Override
    public LinkRelation getCollectionResourceRelFor(Class<?> type) {
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.collectionRelation())) {
            return null;
        }
        return LinkRelation.of(annotation.collectionRelation());
    }

    @Override
    public LinkRelation getItemResourceRelFor(Class<?> type) {
        Relation annotation = this.lookupAnnotation(type);
        if (annotation == null || "".equals(annotation.value())) {
            return null;
        }
        return LinkRelation.of(annotation.value());
    }

    public int getOrder() {
        return 100;
    }

    public boolean supports(Class<?> delimiter) {
        return this.lookupAnnotation(delimiter) != null;
    }

    private Relation lookupAnnotation(Class<?> type) {
        return this.annotationCache.computeIfAbsent(type, key -> (Relation)AnnotationUtils.getAnnotation((AnnotatedElement)key, Relation.class));
    }
}

