/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import java.util.function.Function;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.LinkBuilder;
import org.springframework.hateoas.server.TypedEntityLinks;
import org.springframework.plugin.core.Plugin;
import org.springframework.util.Assert;

public interface EntityLinks
extends Plugin<Class<?>> {
    public LinkBuilder linkFor(Class<?> var1);

    public LinkBuilder linkFor(Class<?> var1, Object ... var2);

    public LinkBuilder linkForItemResource(Class<?> var1, Object var2);

    default public <T> LinkBuilder linkForItemResource(T entity, Function<T, Object> identifierExtractor) {
        Assert.notNull(identifierExtractor, (String)"Identifier extractor must not be null!");
        return this.linkForItemResource(entity.getClass(), identifierExtractor.apply(entity));
    }

    public Link linkToCollectionResource(Class<?> var1);

    public Link linkToItemResource(Class<?> var1, Object var2);

    default public <T> Link linkToItemResource(T entity, Function<T, Object> identifierExtractor) {
        return this.linkToItemResource(entity.getClass(), identifierExtractor.apply(entity));
    }

    default public <T> TypedEntityLinks<T> forType(Function<T, ? extends Object> extractor) {
        return new TypedEntityLinks<T>(extractor, this);
    }

    default public <T> TypedEntityLinks.ExtendedTypedEntityLinks<T> forType(Class<T> type, Function<T, Object> extractor) {
        return new TypedEntityLinks.ExtendedTypedEntityLinks<T>(extractor, this, type);
    }
}

