/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import org.springframework.beans.factory.BeanCreationException;
import org.springframework.context.MessageSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.hateoas.client.LinkDiscoverer;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.hateoas.server.LinkRelationProvider;
import org.springframework.hateoas.server.core.AnnotationLinkRelationProvider;
import org.springframework.hateoas.server.core.DefaultLinkRelationProvider;
import org.springframework.hateoas.server.core.DelegatingLinkRelationProvider;
import org.springframework.hateoas.server.core.EvoInflectorLinkRelationProvider;
import org.springframework.http.MediaType;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.config.EnablePluginRegistries;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.util.ClassUtils;

@Configuration
@EnablePluginRegistries(value={LinkDiscoverer.class})
class HateoasConfiguration {
    HateoasConfiguration() {
    }

    @Bean
    public MessageSourceAccessor linkRelationMessageSource() {
        try {
            ReloadableResourceBundleMessageSource messageSource = new ReloadableResourceBundleMessageSource();
            messageSource.setBasename("classpath:rest-messages");
            return new MessageSourceAccessor((MessageSource)messageSource);
        }
        catch (Exception o_O) {
            throw new BeanCreationException("resourceDescriptionMessageSourceAccessor", "", (Throwable)o_O);
        }
    }

    @Bean
    LinkRelationProvider defaultRelProvider() {
        return ClassUtils.isPresent((String)"org.atteo.evo.inflector.English", null) ? new EvoInflectorLinkRelationProvider() : new DefaultLinkRelationProvider();
    }

    @Bean
    AnnotationLinkRelationProvider annotationRelProvider() {
        return new AnnotationLinkRelationProvider();
    }

    @Primary
    @Bean
    DelegatingLinkRelationProvider _relProvider(PluginRegistry<LinkRelationProvider, Class<?>> relProviderPluginRegistry) {
        return new DelegatingLinkRelationProvider(relProviderPluginRegistry);
    }

    @Bean
    PluginRegistryFactoryBean<LinkRelationProvider, Class<?>> relProviderPluginRegistry() {
        PluginRegistryFactoryBean factory = new PluginRegistryFactoryBean();
        factory.setType(LinkRelationProvider.class);
        factory.setExclusions(new Class[]{DelegatingLinkRelationProvider.class});
        return factory;
    }

    @Bean
    LinkDiscoverers linkDiscoverers(PluginRegistry<LinkDiscoverer, MediaType> discoverers) {
        return new LinkDiscoverers(discoverers);
    }
}

