/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.config;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Primary;
import org.springframework.hateoas.server.EntityLinks;
import org.springframework.hateoas.server.LinkBuilderFactory;
import org.springframework.hateoas.server.core.ControllerEntityLinksFactoryBean;
import org.springframework.hateoas.server.core.DelegatingEntityLinks;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilderFactory;
import org.springframework.plugin.core.PluginRegistry;
import org.springframework.plugin.core.support.PluginRegistryFactoryBean;
import org.springframework.stereotype.Controller;

@Configuration
class EntityLinksConfiguration {
    EntityLinksConfiguration() {
    }

    @Bean
    PluginRegistryFactoryBean<EntityLinks, Class<?>> entityLinksPluginRegistry() {
        PluginRegistryFactoryBean registry = new PluginRegistryFactoryBean();
        registry.setType(EntityLinks.class);
        registry.setExclusions(new Class[]{DelegatingEntityLinks.class});
        return registry;
    }

    @Primary
    @Bean
    @DependsOn(value={"webMvcEntityLinks"})
    DelegatingEntityLinks delegatingEntityLinks(PluginRegistry<EntityLinks, Class<?>> entityLinksPluginRegistry) {
        return new DelegatingEntityLinks(entityLinksPluginRegistry);
    }

    @Bean
    ControllerEntityLinksFactoryBean webMvcEntityLinks(ObjectProvider<WebMvcLinkBuilderFactory> linkBuilderFactory) {
        ControllerEntityLinksFactoryBean factory = new ControllerEntityLinksFactoryBean();
        factory.setAnnotation(Controller.class);
        factory.setLinkBuilderFactory((LinkBuilderFactory)linkBuilderFactory.getIfAvailable(WebMvcLinkBuilderFactory::new));
        return factory;
    }
}

