/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.client;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.Optional;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.client.LinkDiscoverers;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

class Rels {
    Rels() {
    }

    public static Rel getRelFor(String rel, LinkDiscoverers discoverers) {
        Assert.hasText((String)rel, (String)"Relation name must not be null!");
        Assert.notNull((Object)discoverers, (String)"LinkDiscoverers must not be null!");
        if (rel.startsWith("$")) {
            return new JsonPathRel(rel);
        }
        return new LinkDiscovererRel(rel, discoverers);
    }

    private static class JsonPathRel
    implements Rel {
        private final String jsonPath;
        private final String rel;

        private JsonPathRel(String jsonPath) {
            Assert.hasText((String)jsonPath, (String)"JSON path must not be null or empty!");
            this.jsonPath = jsonPath;
            String lastSegment = jsonPath.substring(jsonPath.lastIndexOf(46));
            this.rel = lastSegment.contains("[") ? lastSegment.substring(0, lastSegment.indexOf("[")) : lastSegment;
        }

        @Override
        public Optional<Link> findInResponse(String representation, MediaType mediaType) {
            return Optional.of(new Link(JsonPath.read((String)representation, (String)this.jsonPath, (Predicate[])new Predicate[0]).toString(), this.rel));
        }
    }

    private static class LinkDiscovererRel
    implements Rel {
        private final String rel;
        private final LinkDiscoverers discoverers;

        private LinkDiscovererRel(String rel, LinkDiscoverers discoverers) {
            Assert.hasText((String)rel, (String)"Rel must not be null or empty!");
            Assert.notNull((Object)discoverers, (String)"LinkDiscoverers must not be null!");
            this.rel = rel;
            this.discoverers = discoverers;
        }

        @Override
        public Optional<Link> findInResponse(String response, MediaType mediaType) {
            return this.discoverers.getRequiredLinkDiscovererFor(mediaType).findLinkWithRel(this.rel, response);
        }

        public String toString() {
            return this.rel;
        }
    }

    public static interface Rel {
        public Optional<Link> findInResponse(String var1, MediaType var2);
    }
}

