/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.server.core.MappingDiscoverer;
import org.springframework.http.HttpMethod;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMethod;

public class AnnotationMappingDiscoverer
implements MappingDiscoverer {
    private static final Pattern MULTIPLE_SLASHES = Pattern.compile("/{2,}");
    private final Class<? extends Annotation> annotationType;
    private final String mappingAttributeName;

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation) {
        this(annotation, null);
    }

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation, String mappingAttributeName) {
        Assert.notNull(annotation, (String)"Annotation must not be null!");
        this.annotationType = annotation;
        this.mappingAttributeName = mappingAttributeName;
    }

    @Override
    public String getMapping(Class<?> type) {
        Assert.notNull(type, (String)"Type must not be null!");
        String[] mapping = this.getMappingFrom(AnnotatedElementUtils.findMergedAnnotation(type, this.annotationType));
        return mapping.length == 0 ? null : mapping[0];
    }

    @Override
    public String getMapping(Method method) {
        Assert.notNull((Object)method, (String)"Method must not be null!");
        return this.getMapping(method.getDeclaringClass(), method);
    }

    @Override
    public String getMapping(Class<?> type, Method method) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        String[] mapping = this.getMappingFrom(AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.annotationType));
        String typeMapping = this.getMapping(type);
        if (mapping == null || mapping.length == 0) {
            return typeMapping;
        }
        return typeMapping == null || "/".equals(typeMapping) ? mapping[0] : AnnotationMappingDiscoverer.join(typeMapping, mapping[0]);
    }

    @Override
    public Collection<HttpMethod> getRequestMethod(Class<?> type, Method method) {
        Assert.notNull(type, (String)"Type must not be null!");
        Assert.notNull((Object)method, (String)"Method must not be null!");
        Annotation mergedAnnotation = AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, this.annotationType);
        Object value = AnnotationUtils.getValue((Annotation)mergedAnnotation, (String)"method");
        RequestMethod[] requestMethods = (RequestMethod[])value;
        ArrayList<HttpMethod> requestMethodNames = new ArrayList<HttpMethod>();
        for (RequestMethod requestMethod : requestMethods) {
            requestMethodNames.add(HttpMethod.valueOf((String)requestMethod.toString()));
        }
        return requestMethodNames;
    }

    private String[] getMappingFrom(Annotation annotation) {
        Object value;
        if (annotation == null) {
            return new String[0];
        }
        Object object = value = this.mappingAttributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.mappingAttributeName);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new IllegalStateException(String.format("Unsupported type for the mapping attribute! Support String and String[] but got %s!", value.getClass()));
    }

    private static String join(String typeMapping, String mapping) {
        return MULTIPLE_SLASHES.matcher(typeMapping.concat("/").concat(mapping)).replaceAll("/");
    }
}

