/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.vnderrors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class VndErrors
implements Iterable<VndError> {
    private final List<VndError> vndErrors;

    public VndErrors(String logref, String message, Link ... links) {
        this(new VndError(logref, message, links), new VndError[0]);
    }

    public VndErrors(VndError error, VndError ... errors) {
        Assert.notNull((Object)error, (String)"Error must not be null");
        this.vndErrors = new ArrayList<VndError>(errors.length + 1);
        this.vndErrors.add(error);
        this.vndErrors.addAll(Arrays.asList(errors));
    }

    @JsonCreator
    public VndErrors(List<VndError> errors) {
        Assert.notNull(errors, (String)"Errors must not be null!");
        Assert.isTrue((!errors.isEmpty() ? 1 : 0) != 0, (String)"Errors must not be empty!");
        this.vndErrors = errors;
    }

    protected VndErrors() {
        this.vndErrors = new ArrayList<VndError>();
    }

    public VndErrors add(VndError error) {
        this.vndErrors.add(error);
        return this;
    }

    @JsonValue
    private List<VndError> getErrors() {
        return this.vndErrors;
    }

    @Override
    public Iterator<VndError> iterator() {
        return this.vndErrors.iterator();
    }

    public String toString() {
        return String.format("VndErrors[%s]", StringUtils.collectionToCommaDelimitedString(this.vndErrors));
    }

    public int hashCode() {
        return this.vndErrors.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof VndErrors)) {
            return false;
        }
        VndErrors that = (VndErrors)obj;
        return this.vndErrors.equals(that.vndErrors);
    }

    public static class VndError
    extends RepresentationModel<VndError> {
        @JsonProperty
        private final String logref;
        @JsonProperty
        private final String message;

        public VndError(String logref, String message, Link ... links) {
            Assert.hasText((String)logref, (String)"Logref must not be null or empty!");
            Assert.hasText((String)message, (String)"Message must not be null or empty!");
            this.logref = logref;
            this.message = message;
            this.add(Arrays.asList(links));
        }

        protected VndError() {
            this.logref = null;
            this.message = null;
        }

        public String getLogref() {
            return this.logref;
        }

        public String getMessage() {
            return this.message;
        }

        @Override
        public String toString() {
            return String.format("VndError[logref: %s, message: %s, links: [%s]]", this.logref, this.message, this.getLinks().toString());
        }

        @Override
        public int hashCode() {
            int result = 17;
            result += 31 * this.logref.hashCode();
            return result += 31 * this.message.hashCode();
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof VndError)) {
                return false;
            }
            VndError that = (VndError)obj;
            return this.logref.equals(that.logref) && this.message.equals(that.message);
        }
    }
}

