/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.mediatype.collectionjson;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.PropertyUtils;
import org.springframework.hateoas.mediatype.collectionjson.CollectionJsonData;
import org.springframework.http.HttpMethod;

class CollectionJsonAffordanceModel
extends AffordanceModel {
    private static final Set<HttpMethod> ENTITY_ALTERING_METHODS = EnumSet.of(HttpMethod.POST, HttpMethod.PUT, HttpMethod.PATCH);
    private final List<CollectionJsonData> inputProperties = this.determineInputs();
    private final List<CollectionJsonData> queryProperties = this.determineQueryProperties();

    public CollectionJsonAffordanceModel(String name, Link link, HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        super(name, link, httpMethod, inputType, queryMethodParameters, outputType);
    }

    private List<CollectionJsonData> determineInputs() {
        if (!ENTITY_ALTERING_METHODS.contains(this.getHttpMethod())) {
            return Collections.emptyList();
        }
        return PropertyUtils.findPropertyNames(this.getInputType()).stream().map(propertyName -> new CollectionJsonData().withName((String)propertyName).withValue("")).collect(Collectors.toList());
    }

    private List<CollectionJsonData> determineQueryProperties() {
        if (!this.getHttpMethod().equals((Object)HttpMethod.GET)) {
            return Collections.emptyList();
        }
        return this.getQueryMethodParameters().stream().map(queryProperty -> new CollectionJsonData().withName(queryProperty.getName()).withValue("")).collect(Collectors.toList());
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionJsonAffordanceModel)) {
            return false;
        }
        CollectionJsonAffordanceModel other = (CollectionJsonAffordanceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<CollectionJsonData> this$inputProperties = this.getInputProperties();
        List<CollectionJsonData> other$inputProperties = other.getInputProperties();
        if (this$inputProperties == null ? other$inputProperties != null : !((Object)this$inputProperties).equals(other$inputProperties)) {
            return false;
        }
        List<CollectionJsonData> this$queryProperties = this.getQueryProperties();
        List<CollectionJsonData> other$queryProperties = other.getQueryProperties();
        return !(this$queryProperties == null ? other$queryProperties != null : !((Object)this$queryProperties).equals(other$queryProperties));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CollectionJsonAffordanceModel;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<CollectionJsonData> $inputProperties = this.getInputProperties();
        result = result * 59 + ($inputProperties == null ? 43 : ((Object)$inputProperties).hashCode());
        List<CollectionJsonData> $queryProperties = this.getQueryProperties();
        result = result * 59 + ($queryProperties == null ? 43 : ((Object)$queryProperties).hashCode());
        return result;
    }

    @Generated
    public List<CollectionJsonData> getInputProperties() {
        return this.inputProperties;
    }

    @Generated
    public List<CollectionJsonData> getQueryProperties() {
        return this.queryProperties;
    }
}

