/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.springframework.hateoas.LinkRelation;
import org.springframework.util.Assert;

final class StringLinkRelation
implements LinkRelation,
Serializable {
    private static final long serialVersionUID = -3904935345545567957L;
    private static final Map<String, StringLinkRelation> CACHE = new ConcurrentHashMap<String, StringLinkRelation>(256);
    @NonNull
    private final String relation;

    @JsonCreator
    public static StringLinkRelation of(String relation) {
        Assert.hasText((String)relation, (String)"Relation must not be null or empty!");
        return CACHE.computeIfAbsent(relation, StringLinkRelation::new);
    }

    @Override
    @JsonValue
    public String value() {
        return this.relation;
    }

    public String toString() {
        return this.value();
    }

    public int hashCode() {
        return this.relation.toLowerCase(Locale.US).hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StringLinkRelation that = (StringLinkRelation)o;
        return this.relation.equalsIgnoreCase(that.relation);
    }

    @NonNull
    @Generated
    public String getRelation() {
        return this.relation;
    }

    @Generated
    private StringLinkRelation(@NonNull String relation) {
        if (relation == null) {
            throw new IllegalArgumentException("relation is marked @NonNull but is null");
        }
        this.relation = relation;
    }
}

