/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.hateoas.AffordanceModel;
import org.springframework.hateoas.AffordanceModelFactory;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.QueryParameter;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;

public final class Affordance {
    private static List<AffordanceModelFactory> factories = SpringFactoriesLoader.loadFactories(AffordanceModelFactory.class, (ClassLoader)Affordance.class.getClassLoader());
    private final Map<MediaType, AffordanceModel> affordanceModels = new HashMap<MediaType, AffordanceModel>();

    public Affordance(String name, Link link, HttpMethod httpMethod, ResolvableType inputType, List<QueryParameter> queryMethodParameters, ResolvableType outputType) {
        Assert.notNull((Object)httpMethod, (String)"httpMethod must not be null!");
        Assert.notNull(queryMethodParameters, (String)"queryMethodParameters must not be null!");
        for (AffordanceModelFactory factory : factories) {
            this.affordanceModels.put(factory.getMediaType(), factory.getAffordanceModel(name, link, httpMethod, inputType, queryMethodParameters, outputType));
        }
    }

    public <T extends AffordanceModel> T getAffordanceModel(MediaType mediaType) {
        return (T)this.affordanceModels.get(mediaType);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Affordance)) {
            return false;
        }
        Affordance other = (Affordance)o;
        Map<MediaType, AffordanceModel> this$affordanceModels = this.getAffordanceModels();
        Map<MediaType, AffordanceModel> other$affordanceModels = other.getAffordanceModels();
        return !(this$affordanceModels == null ? other$affordanceModels != null : !((Object)this$affordanceModels).equals(other$affordanceModels));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<MediaType, AffordanceModel> $affordanceModels = this.getAffordanceModels();
        result = result * 59 + ($affordanceModels == null ? 43 : ((Object)$affordanceModels).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Affordance(affordanceModels=" + this.getAffordanceModels() + ")";
    }

    @Generated
    Map<MediaType, AffordanceModel> getAffordanceModels() {
        return this.affordanceModels;
    }
}

