/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.query;

import graphql.schema.DataFetchingEnvironment;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.data.domain.Sort;
import org.springframework.graphql.data.query.SortStrategy;
import org.springframework.util.ObjectUtils;

public abstract class AbstractSortStrategy
implements SortStrategy {
    @Override
    public Sort extract(DataFetchingEnvironment environment) {
        List<String> properties = this.getProperties(environment);
        if (!ObjectUtils.isEmpty(properties)) {
            Sort.Direction direction = this.getDirection(environment);
            direction = direction != null ? direction : Sort.DEFAULT_DIRECTION;
            ArrayList<Sort.Order> sortOrders = new ArrayList<Sort.Order>(properties.size());
            for (String property : properties) {
                sortOrders.add(new Sort.Order(direction, property));
            }
            return Sort.by(sortOrders);
        }
        return Sort.unsorted();
    }

    protected abstract List<String> getProperties(DataFetchingEnvironment var1);

    protected abstract // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Sort.Direction getDirection(DataFetchingEnvironment var1);
}

