/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.execution;

import io.micrometer.context.ThreadLocalAccessor;
import org.jspecify.annotations.Nullable;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.util.ClassUtils;

public class SecurityContextThreadLocalAccessor
implements ThreadLocalAccessor<Object> {
    private static final boolean springSecurityPresent = ClassUtils.isPresent((String)"org.springframework.security.core.context.SecurityContext", (ClassLoader)SecurityContextThreadLocalAccessor.class.getClassLoader());
    private final ThreadLocalAccessor<?> delegate = springSecurityPresent ? new DelegateAccessor() : new NoOpAccessor();

    public Object key() {
        return this.delegate.key();
    }

    public @Nullable Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object value) {
        this.setValueInternal(value);
    }

    private <V> void setValueInternal(Object value) {
        this.delegate.setValue(value);
    }

    public void setValue() {
        this.delegate.setValue();
    }

    @Deprecated(since="1.3.0", forRemoval=true)
    public void reset() {
        this.delegate.reset();
    }

    public void restore(Object previousValue) {
        this.restoreInternal(previousValue);
    }

    public <V> void restoreInternal(Object previousValue) {
        this.delegate.restore(previousValue);
    }

    public void restore() {
        this.delegate.restore();
    }

    private static final class DelegateAccessor
    implements ThreadLocalAccessor<Object> {
        private DelegateAccessor() {
        }

        public Object key() {
            return SecurityContext.class.getName();
        }

        public Object getValue() {
            return SecurityContextHolder.getContext();
        }

        public void setValue(Object value) {
            SecurityContextHolder.setContext((SecurityContext)((SecurityContext)value));
        }

        public void setValue() {
            SecurityContextHolder.clearContext();
        }

        public void restore(Object previousValue) {
            SecurityContextHolder.setContext((SecurityContext)((SecurityContext)previousValue));
        }

        public void restore() {
            SecurityContextHolder.clearContext();
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public void reset() {
            SecurityContextHolder.clearContext();
        }
    }

    private static final class NoOpAccessor
    implements ThreadLocalAccessor<Object> {
        private NoOpAccessor() {
        }

        public Object key() {
            return this.getClass().getName();
        }

        public @Nullable Object getValue() {
            return null;
        }

        public void setValue(Object value) {
        }

        public void setValue() {
        }

        public void restore(Object previousValue) {
        }

        public void restore() {
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public void reset() {
        }
    }
}

