/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.pagination;

import java.util.Collection;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.graphql.data.pagination.ConnectionAdapter;
import org.springframework.util.Assert;

final class CompositeConnectionAdapter
implements ConnectionAdapter {
    private final List<ConnectionAdapter> adapters;

    CompositeConnectionAdapter(List<ConnectionAdapter> adapters) {
        Assert.notEmpty(adapters, (String)"ConnectionAdapter's are required");
        this.adapters = adapters;
    }

    @Override
    public boolean supports(Class<?> containerType) {
        return this.getAdapter(containerType) != null;
    }

    @Override
    public <T> Collection<T> getContent(Object container) {
        return this.getRequiredAdapter(container).getContent(container);
    }

    @Override
    public boolean hasPrevious(Object container) {
        return this.getRequiredAdapter(container).hasPrevious(container);
    }

    @Override
    public boolean hasNext(Object container) {
        return this.getRequiredAdapter(container).hasNext(container);
    }

    @Override
    public String cursorAt(Object container, int index) {
        return this.getRequiredAdapter(container).cursorAt(container, index);
    }

    private ConnectionAdapter getRequiredAdapter(Object container) {
        ConnectionAdapter adapter = this.getAdapter(container.getClass());
        Assert.notNull((Object)adapter, (String)("No ConnectionAdapter for: " + container.getClass().getName()));
        return adapter;
    }

    private @Nullable ConnectionAdapter getAdapter(Class<?> containerType) {
        for (ConnectionAdapter adapter : this.adapters) {
            if (!adapter.supports(containerType)) continue;
            return adapter;
        }
        return null;
    }
}

