/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data;

import java.util.Optional;
import java.util.function.Consumer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ArgumentValue<T> {
    private static final ArgumentValue<?> EMPTY = new ArgumentValue<Object>(null, false);
    private static final ArgumentValue<?> OMITTED = new ArgumentValue<Object>(null, true);
    @Nullable
    private final T value;
    private final boolean omitted;

    private ArgumentValue(@Nullable T value, boolean omitted) {
        this.value = value;
        this.omitted = omitted;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isEmpty() {
        return !this.omitted && this.value == null;
    }

    public boolean isOmitted() {
        return this.omitted;
    }

    @Nullable
    public T value() {
        return this.value;
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public void ifPresent(Consumer<? super T> action) {
        Assert.notNull(action, (String)"Action is required");
        if (this.value != null) {
            action.accept(this.value);
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ArgumentValue)) {
            return false;
        }
        ArgumentValue otherValue = (ArgumentValue)other;
        return ObjectUtils.nullSafeEquals(this.value, otherValue.value);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode(this.value);
        result = 31 * result + Boolean.hashCode(this.omitted);
        return result;
    }

    public static <T> ArgumentValue<T> ofNullable(@Nullable T value) {
        return value != null ? new ArgumentValue<T>(value, false) : EMPTY;
    }

    public static <T> ArgumentValue<T> omitted() {
        return OMITTED;
    }
}

