/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.data.federation;

import graphql.schema.DataFetchingEnvironment;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import org.springframework.graphql.data.federation.EntityArgumentMethodArgumentResolver;
import org.springframework.graphql.data.federation.FederationSchemaFactory;
import org.springframework.graphql.data.method.HandlerMethodArgumentResolverComposite;
import org.springframework.graphql.data.method.annotation.support.DataFetcherHandlerMethodSupport;
import org.springframework.graphql.execution.ReactiveAdapterRegistryHelper;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Mono;

final class EntityHandlerMethod
extends DataFetcherHandlerMethodSupport {
    private final boolean batchHandlerMethod;

    EntityHandlerMethod(FederationSchemaFactory.EntityMappingInfo info, HandlerMethodArgumentResolverComposite resolvers, @Nullable Executor executor, boolean invokeAsync) {
        super(info.handlerMethod(), resolvers, executor, invokeAsync);
        this.batchHandlerMethod = info.isBatchHandlerMethod();
    }

    boolean isBatchHandlerMethod() {
        return this.batchHandlerMethod;
    }

    Mono<Object> getEntity(DataFetchingEnvironment env, Map<String, Object> representation) {
        env = EntityArgumentMethodArgumentResolver.wrap(env, representation);
        return this.doInvoke(env);
    }

    Mono<Object> getEntities(DataFetchingEnvironment env, List<Map<String, Object>> representations) {
        env = EntityArgumentMethodArgumentResolver.wrap(env, representations);
        return this.doInvoke(env);
    }

    private Mono<Object> doInvoke(DataFetchingEnvironment env) {
        Object[] args;
        try {
            args = this.getMethodArgumentValues(env, new Object[0]);
        }
        catch (Throwable ex) {
            return Mono.error((Throwable)ex);
        }
        Object result = this.doInvoke(env.getGraphQlContext(), args);
        return ReactiveAdapterRegistryHelper.toMono(result);
    }
}

