/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graphql.test.tester;

import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.spi.json.AbstractJsonProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.ObjectReader;

class JacksonJsonProvider
extends AbstractJsonProvider {
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final ObjectReader objectReader = this.objectMapper.reader();

    JacksonJsonProvider() {
    }

    public Object parse(String json) throws InvalidJsonException {
        try {
            return this.objectReader.readValue(json);
        }
        catch (JacksonException exc) {
            throw new InvalidJsonException((Throwable)exc, json);
        }
    }

    public Object parse(InputStream jsonStream, String charset) throws InvalidJsonException {
        try {
            return this.objectReader.readValue((Reader)new InputStreamReader(jsonStream, charset));
        }
        catch (IOException exc) {
            throw new InvalidJsonException((Throwable)exc);
        }
    }

    public String toJson(Object obj) {
        StringWriter writer = new StringWriter();
        try {
            JsonGenerator generator = this.objectMapper.createGenerator((Writer)writer);
            this.objectMapper.writeValue(generator, obj);
            writer.flush();
            writer.close();
            generator.close();
            return writer.getBuffer().toString();
        }
        catch (IOException exc) {
            throw new InvalidJsonException((Throwable)exc);
        }
    }

    public Object createArray() {
        return new LinkedList();
    }

    public Object createMap() {
        return new LinkedHashMap();
    }
}

