/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.internal.svm;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.ProxyMethodInvocation;
import org.springframework.internal.svm.OnlyPresent;

@TargetClass(className="org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor", onlyWith={OnlyPresent.class})
public final class Target_DefaultMethodInvokingMethodInterceptor {
    @Substitute
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Method method = invocation.getMethod();
        if (!method.isDefault()) {
            return invocation.proceed();
        }
        Object[] arguments = invocation.getArguments();
        Object proxy = ((ProxyMethodInvocation)invocation).getProxy();
        try {
            return method.invoke(proxy, arguments);
        }
        catch (UndeclaredThrowableException ute) {
            System.out.println("UNDECLARED THROWABLE: " + ute.getUndeclaredThrowable());
            throw ute;
        }
    }
}

