/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.type;

import java.util.LinkedHashMap;
import java.util.Map;

public class CompilationHint {
    private String targetType;
    private Map<String, Integer> specificTypes = new LinkedHashMap<String, Integer>();
    public boolean follow = false;
    public boolean skipIfTypesMissing = false;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("CompilationHint");
        if (this.targetType != null) {
            sb.append(" for ").append(this.targetType);
        }
        sb.append(":");
        sb.append(this.specificTypes);
        return sb.toString();
    }

    public void setTargetType(String targetTypename) {
        this.targetType = targetTypename;
    }

    public String getTargetType() {
        return this.targetType;
    }

    public Map<String, Integer> getDependantTypes() {
        return this.specificTypes;
    }

    public void addDependantType(String className, Integer accessBits) {
        this.specificTypes.put(className, accessBits);
    }

    public void setAbortIfTypesMissing(Boolean b) {
        this.skipIfTypesMissing = b;
    }

    public boolean isAbortIfTypesMissing() {
        return this.skipIfTypesMissing;
    }

    public void setFollow(Boolean b) {
        this.follow = b;
    }
}

