/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import org.springframework.graal.domain.reflect.ClassDescriptor;
import org.springframework.graal.domain.reflect.JsonMarshaller;
import org.springframework.graal.domain.reflect.ReflectionDescriptor;

public class ReflectionJsonSorter {
    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.out.println("Usage: ReflectionJsonSorter <reflect-config.json>");
            System.exit(1);
        }
        ReflectionDescriptor rd = null;
        try (FileInputStream fis = new FileInputStream(new File(args[0]));){
            rd = JsonMarshaller.read(fis);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem loading file", e);
        }
        List<ClassDescriptor> classDescriptors = rd.getClassDescriptors();
        classDescriptors.sort((a, b) -> a.getName().compareTo(b.getName()));
        rd = new ReflectionDescriptor();
        for (ClassDescriptor cd : classDescriptors) {
            rd.add(cd);
        }
        try {
            JsonMarshaller.write(rd, new PrintStream(System.out));
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem loading file", e);
        }
    }
}

