/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.support;

import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.springframework.graal.domain.buildtimeinit.InitializationDescriptor;
import org.springframework.graal.domain.buildtimeinit.InitializationJsonMarshaller;
import org.springframework.graal.support.SpringFeature;

public class InitializationHandler {
    public InitializationDescriptor compute() {
        try {
            InputStream s = this.getClass().getResourceAsStream("/initialization.json");
            return InitializationJsonMarshaller.read(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void register(Feature.BeforeAnalysisAccess access) {
        InitializationDescriptor id = this.compute();
        System.out.println("Configuring initialization time for specific types and packages:");
        if (id == null) {
            throw new IllegalStateException("Unable to load initialization descriptor");
        }
        System.out.println(id.toString());
        List<Class> collect = id.getBuildtimeClasses().stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        RuntimeClassInitialization.initializeAtBuildTime((Class[])collect.toArray(new Class[0]));
        id.getRuntimeClasses().stream().map(arg_0 -> ((Feature.BeforeAnalysisAccess)access).findClassByName(arg_0)).filter(Objects::nonNull).forEach(xva$0 -> RuntimeClassInitialization.initializeAtRunTime((Class[])new Class[]{xva$0}));
        SpringFeature.log("Registering these packages for buildtime initialization: \n" + id.getBuildtimePackages());
        RuntimeClassInitialization.initializeAtBuildTime((String[])id.getBuildtimePackages().toArray(new String[0]));
        SpringFeature.log("Registering these packages for runtime initialization: \n" + id.getRuntimePackages());
        RuntimeClassInitialization.initializeAtRunTime((String[])id.getRuntimePackages().toArray(new String[0]));
    }
}

