/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.support;

public abstract class ConfigOptions {
    private static final boolean REMOVE_UNUSED_AUTOCONFIG = Boolean.valueOf(System.getProperty("spring.graal.remove-unused-autoconfig", "false"));
    private static final boolean SKIP_LOGBACK;
    private static final boolean REMOVE_YAML_SUPPORT;
    private static final String DUMP_CONFIG;
    private static final boolean VERBOSE;
    private static final String MISSING_SELECTOR_HINTS;
    private static final String MODE;

    public static boolean shouldRemoveUnusedAutoconfig() {
        return REMOVE_UNUSED_AUTOCONFIG;
    }

    public static boolean areMissingSelectorHintsAnError() {
        return MISSING_SELECTOR_HINTS.equals("error");
    }

    public static boolean isVerbose() {
        return VERBOSE;
    }

    public static boolean shouldDumpConfig() {
        return DUMP_CONFIG != null;
    }

    public static boolean shouldSkipLogback() {
        return SKIP_LOGBACK;
    }

    public static boolean shouldRemoveYamlSupport() {
        return REMOVE_YAML_SUPPORT;
    }

    public static boolean isInitializationModeOnly() {
        return MODE.equals("initialization-only");
    }

    public static String getDumpConfigLocation() {
        return DUMP_CONFIG;
    }

    static {
        if (REMOVE_UNUSED_AUTOCONFIG) {
            System.out.println("Removing unused configurations");
        }
        if (VERBOSE = Boolean.valueOf(System.getProperty("spring.graal.verbose", "false")).booleanValue()) {
            System.out.println("Turning on verbose mode for the feature");
        }
        if ((MISSING_SELECTOR_HINTS = System.getProperty("spring.graal.missing-selector-hints", "error")).equals("warning")) {
            System.out.println("Selectors missing hints will be reported as a warning, not an error");
        } else if (!MISSING_SELECTOR_HINTS.equals("error")) {
            throw new IllegalStateException("Supported values for 'spring.graal.missing-selector-hints' are 'error' (default) or 'warning'");
        }
        MODE = System.getProperty("spring.graal.mode", "default");
        if (MODE.equals("initialization-only")) {
            System.out.println("Feature operating in initialization-only mode, only supplying substitutions and initialization data");
        } else if (!MODE.equals("default")) {
            throw new IllegalStateException("Supported modes are 'default' or 'initialization-only', not '" + MODE + "'");
        }
        SKIP_LOGBACK = Boolean.valueOf(System.getProperty("spring.graal.skip-logback", "false"));
        if (SKIP_LOGBACK) {
            System.out.println("Skipping logback configuration");
        }
        if (REMOVE_YAML_SUPPORT = Boolean.valueOf(System.getProperty("spring.graal.remove-yaml-support", "false")).booleanValue()) {
            System.out.println("Skipping Yaml support");
        }
        if ((DUMP_CONFIG = System.getProperty("spring.graal.dump-config")) != null) {
            System.out.println("Dumping computed config to " + DUMP_CONFIG);
        }
    }
}

