/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.proxies;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.graal.domain.proxies.ProxiesDescriptorJsonMarshaller;
import org.springframework.graal.domain.proxies.ProxyDescriptor;

public class ProxiesDescriptor {
    private final List<ProxyDescriptor> proxyDescriptors;

    public ProxiesDescriptor() {
        this.proxyDescriptors = new ArrayList<ProxyDescriptor>();
    }

    public ProxiesDescriptor(ProxiesDescriptor metadata) {
        this.proxyDescriptors = new ArrayList<ProxyDescriptor>(metadata.proxyDescriptors);
    }

    public List<ProxyDescriptor> getProxyDescriptors() {
        return this.proxyDescriptors;
    }

    public void add(ProxyDescriptor proxyDescriptor) {
        this.proxyDescriptors.add(proxyDescriptor);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("ProxyDescriptors #%s\n", this.proxyDescriptors.size()));
        this.proxyDescriptors.forEach(cd -> result.append(String.format("%s: \n", cd)));
        return result.toString();
    }

    public boolean isEmpty() {
        return this.proxyDescriptors.isEmpty();
    }

    public static ProxiesDescriptor of(String jsonString) {
        try {
            return ProxiesDescriptorJsonMarshaller.read(jsonString);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to read json:\n" + jsonString, e);
        }
    }

    public void consume(Consumer<List<String>> consumer) {
        this.proxyDescriptors.stream().forEach(pd -> consumer.accept(pd.getInterfaces()));
    }
}

