/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.graal.domain.buildtimeinit;

import org.springframework.graal.domain.buildtimeinit.InitializationDescriptor;
import org.springframework.graal.json.JSONArray;
import org.springframework.graal.json.JSONObject;

class InitializationJsonConverter {
    InitializationJsonConverter() {
    }

    public JSONObject toJsonArray(InitializationDescriptor metadata) throws Exception {
        JSONObject object = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (String p : metadata.getBuildtimeClasses()) {
            jsonArray.put(this.toClassJsonObject(p));
        }
        for (String p : metadata.getBuildtimePackages()) {
            jsonArray.put(this.toPackageJsonObject(p));
        }
        object.put("buildTimeInitialization", jsonArray);
        for (String p : metadata.getRuntimeClasses()) {
            jsonArray.put(this.toClassJsonObject(p));
        }
        for (String p : metadata.getRuntimePackages()) {
            jsonArray.put(this.toPackageJsonObject(p));
        }
        object.put("runtimeInitialization", jsonArray);
        return object;
    }

    public JSONObject toPackageJsonObject(String pattern) throws Exception {
        JSONObject object = new JSONObject();
        object.put("package", pattern);
        return object;
    }

    public JSONObject toClassJsonObject(String pattern) throws Exception {
        JSONObject object = new JSONObject();
        object.put("class", pattern);
        return object;
    }
}

