/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.context.bootstrap.generator;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.WildcardTypeName;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;
import org.springframework.aot.context.bootstrap.generator.ApplicationContextAotProcessor;
import org.springframework.aot.context.bootstrap.generator.infrastructure.BootstrapClass;
import org.springframework.aot.context.bootstrap.generator.infrastructure.BootstrapWriterContext;
import org.springframework.aot.context.bootstrap.generator.infrastructure.nativex.NativeConfigurationRegistry;
import org.springframework.aot.test.context.bootstrap.generator.TestContextConfigurationDescriptor;
import org.springframework.aot.test.context.bootstrap.generator.TestContextConfigurationDescriptorFactory;
import org.springframework.aot.test.context.bootstrap.generator.nativex.TestNativeConfigurationRegistrar;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.SmartContextLoader;

public class TestContextAotProcessor {
    private static final String TEST_BOOTSTRAP_CLASS_NAME = "TestContextBootstrapInitializer";
    private final TestContextConfigurationDescriptorFactory configurationDescriptorFactory;
    private final ApplicationContextAotProcessor contextProcessor;
    private final TestNativeConfigurationRegistrar testNativeConfigurationRegistrar;

    public TestContextAotProcessor(ClassLoader classLoader) {
        this.configurationDescriptorFactory = new TestContextConfigurationDescriptorFactory(classLoader);
        this.contextProcessor = new ApplicationContextAotProcessor(classLoader);
        this.testNativeConfigurationRegistrar = new TestNativeConfigurationRegistrar(classLoader);
    }

    public void generateTestContexts(Iterable<Class<?>> testClasses, BootstrapWriterContext writerContext) {
        NativeConfigurationRegistry nativeConfigurationRegistry = writerContext.getNativeConfigurationRegistry();
        List<TestContextConfigurationDescriptor> descriptors = this.configurationDescriptorFactory.buildConfigurationDescriptors(testClasses);
        AtomicInteger count = new AtomicInteger();
        Supplier<ClassName> fallbackClassName = () -> ClassName.get((String)"org.springframework.aot", (String)(TEST_BOOTSTRAP_CLASS_NAME + count.getAndIncrement()), (String[])new String[0]);
        HashMap<ClassName, TestContextConfigurationDescriptor> entries = new HashMap<ClassName, TestContextConfigurationDescriptor>();
        for (TestContextConfigurationDescriptor descriptor : descriptors) {
            ClassName className = this.generateTestContext(writerContext, fallbackClassName, descriptor);
            descriptor.contributeNativeConfiguration(nativeConfigurationRegistry);
            nativeConfigurationRegistry.reflection().forGeneratedType(className).withMethods(new MethodSpec[]{MethodSpec.constructorBuilder().build()});
            entries.put(className, descriptor);
        }
        this.generateMappingMethods(writerContext, entries);
        this.testNativeConfigurationRegistrar.processTestConfigurations(nativeConfigurationRegistry, entries.values().stream().map(TestContextConfigurationDescriptor::getContextConfiguration).collect(Collectors.toList()));
    }

    private void generateMappingMethods(BootstrapWriterContext writerContext, Map<ClassName, TestContextConfigurationDescriptor> entries) {
        BootstrapWriterContext mainWriterContext = writerContext.fork(TEST_BOOTSTRAP_CLASS_NAME, packageName -> {
            ClassName mainClassName = ClassName.get((String)packageName, (String)TEST_BOOTSTRAP_CLASS_NAME, (String[])new String[0]);
            return BootstrapClass.of((ClassName)mainClassName, type -> type.addModifiers(new Modifier[]{Modifier.PUBLIC}));
        });
        BootstrapClass boostrapClass = mainWriterContext.getMainBootstrapClass();
        MethodSpec contextLoadersMappingMethod = boostrapClass.addMethod(this.contextLoadersMappingMethod(entries));
        MethodSpec contextInitializersMappingMethod = boostrapClass.addMethod(this.contextInitializersMappingMethod(entries));
        writerContext.getNativeConfigurationRegistry().reflection().forGeneratedType(boostrapClass.getClassName()).withMethods(new MethodSpec[]{contextLoadersMappingMethod, contextInitializersMappingMethod});
    }

    protected ClassName generateTestContext(BootstrapWriterContext writerContext, Supplier<ClassName> fallbackClassName, TestContextConfigurationDescriptor descriptor) {
        GenericApplicationContext context = descriptor.parseTestContext();
        ClassName className = this.determineClassName(descriptor.getTestClasses(), fallbackClassName);
        BootstrapWriterContext testWriterContext = writerContext.fork(className);
        this.contextProcessor.process(context, testWriterContext);
        BootstrapClass mainBootstrapClass = testWriterContext.getMainBootstrapClass();
        mainBootstrapClass.customizeType(type -> type.addJavadoc(this.getClassLevelJavadoc(descriptor.getTestClasses())));
        return mainBootstrapClass.getClassName();
    }

    private MethodSpec.Builder contextLoadersMappingMethod(Map<ClassName, TestContextConfigurationDescriptor> entries) {
        CodeBlock.Builder code = CodeBlock.builder();
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), ParameterizedTypeName.get(Supplier.class, (Type[])new Type[]{SmartContextLoader.class})});
        code.addStatement("$T entries = new $T<>()", new Object[]{mapType, HashMap.class});
        entries.forEach((className, descriptor) -> descriptor.getTestClasses().forEach(testClass -> {
            code.add("entries.put($S, ", new Object[]{testClass.getName()});
            code.add(descriptor.writeTestContextLoaderInstanceSupplier((ClassName)className));
            code.addStatement(")", new Object[0]);
        }));
        code.addStatement("return entries", new Object[0]);
        return MethodSpec.methodBuilder((String)"getContextLoaders").returns((TypeName)mapType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addCode(code.build());
    }

    private MethodSpec.Builder contextInitializersMappingMethod(Map<ClassName, TestContextConfigurationDescriptor> entries) {
        WildcardTypeName classWildcard = WildcardTypeName.subtypeOf((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ApplicationContextInitializer.class), (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf(Object.class)}));
        ParameterizedTypeName classType = ParameterizedTypeName.get((ClassName)ClassName.get(Class.class), (TypeName[])new TypeName[]{classWildcard});
        ParameterizedTypeName mapType = ParameterizedTypeName.get((ClassName)ClassName.get(Map.class), (TypeName[])new TypeName[]{ClassName.get(String.class), classType});
        CodeBlock.Builder code = CodeBlock.builder();
        code.addStatement("$T entries = new $T<>()", new Object[]{mapType, HashMap.class});
        entries.forEach((className, descriptor) -> descriptor.getTestClasses().forEach(testClass -> code.addStatement("entries.put($S, $T.class)", new Object[]{testClass.getName(), className})));
        code.addStatement("return entries", new Object[0]);
        return MethodSpec.methodBuilder((String)"getContextInitializers").returns((TypeName)mapType).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).addCode(code.build());
    }

    private CodeBlock getClassLevelJavadoc(List<Class<?>> testClasses) {
        CodeBlock.Builder code = CodeBlock.builder();
        code.add("AOT generated context for ", new Object[0]);
        List testClassNames = testClasses.stream().map(testClass -> String.format("{@code %s}", testClass.getSimpleName())).collect(Collectors.toList());
        if (testClasses.size() == 1) {
            code.add((String)testClassNames.get(0), new Object[0]);
        } else {
            int last = testClassNames.size() - 1;
            String lastSeparator = testClassNames.size() == 2 ? " and " : ", and ";
            code.add(String.join((CharSequence)lastSeparator, String.join((CharSequence)", ", testClassNames.subList(0, last)), (CharSequence)testClassNames.get(last)), new Object[0]);
        }
        code.add(".", new Object[0]);
        return code.build();
    }

    private ClassName determineClassName(List<Class<?>> testClasses, Supplier<ClassName> fallback) {
        if (testClasses.size() == 1) {
            Class<?> testClass = testClasses.get(0);
            return ClassName.get((String)testClass.getPackageName(), (String)String.format("%sContextInitializer", testClass.getSimpleName()), (String[])new String[0]);
        }
        return fallback.get();
    }
}

