/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.build;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.springframework.aot.build.AotPhase;
import org.springframework.aot.build.ApplicationStructure;
import org.springframework.aot.build.BootstrapCodeGenerator;
import org.springframework.aot.build.BootstrapContributor;
import org.springframework.aot.test.build.TestClassesFinder;
import org.springframework.boot.logging.LogFile;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingInitializationContext;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.nativex.AotOptions;
import org.springframework.util.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(mixinStandardHelpOptions=true, description={"Generate the Java source for the Spring test Bootstrap class."})
public class GenerateTestBootstrapCommand
implements Callable<Integer> {
    @CommandLine.Option(names={"--sources-out"}, required=true, description={"Output path for the generated sources."})
    private Path sourceOutputPath;
    @CommandLine.Option(names={"--resources-out"}, required=true, description={"Output path for the generated resources."})
    private Path resourcesOutputPath;
    @CommandLine.Option(names={"--resources"}, required=true, split="${sys:path.separator}", description={"Paths to the application compiled resources."})
    private Set<Path> resourcesPaths;
    @CommandLine.Option(names={"--mode"}, required=true, description={"The mode which could be native or native-agent"})
    private String mode;
    @CommandLine.Option(names={"--debug"}, description={"Enable debug logging."})
    private boolean isDebug;
    @CommandLine.Option(names={"--remove-yaml"}, description={"Remove Yaml support."})
    private boolean removeYaml;
    @CommandLine.Option(names={"--remove-jmx"}, description={"Remove JMX support."})
    private boolean removeJmx;
    @CommandLine.Option(names={"--remove-xml"}, description={"Remove XML support."})
    private boolean removeXml;
    @CommandLine.Option(names={"--remove-spel"}, description={"Remove SpEL support."})
    private boolean removeSpel;
    @CommandLine.Parameters(index="0", arity="1..*", description={"Folders containing the application test classes."})
    private Path[] testClassesFolders;

    @Override
    public Integer call() throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ArrayList<String> testClassesNames = new ArrayList<String>();
        for (Path testClassesFolder : this.testClassesFolders) {
            testClassesNames.addAll(TestClassesFinder.findTestClasses(testClassesFolder));
        }
        AotOptions aotOptions = new AotOptions();
        aotOptions.setMode(this.mode);
        aotOptions.setDebugVerify(this.isDebug);
        aotOptions.setRemoveYamlSupport(this.removeYaml);
        aotOptions.setRemoveJmxSupport(this.removeJmx);
        aotOptions.setRemoveXmlSupport(this.removeXml);
        aotOptions.setRemoveSpelSupport(this.removeSpel);
        StandardEnvironment environment = new StandardEnvironment();
        LogFile logFile = LogFile.get((PropertyResolver)environment);
        LoggingInitializationContext initializationContext = new LoggingInitializationContext((ConfigurableEnvironment)environment);
        LoggingSystem loggingSystem = LoggingSystem.get((ClassLoader)classLoader);
        loggingSystem.initialize(initializationContext, null, logFile);
        if (this.isDebug) {
            loggingSystem.setLogLevel(null, LogLevel.DEBUG);
        }
        List bootstrapContributors = SpringFactoriesLoader.loadFactories(BootstrapContributor.class, (ClassLoader)classLoader);
        BootstrapCodeGenerator generator = new BootstrapCodeGenerator(aotOptions, bootstrapContributors);
        String[] classPath = StringUtils.tokenizeToStringArray((String)System.getProperty("java.class.path"), (String)File.pathSeparator);
        ApplicationStructure applicationStructure = new ApplicationStructure(this.sourceOutputPath, this.resourcesOutputPath, this.resourcesPaths, Arrays.asList(this.testClassesFolders), null, null, testClassesNames, Arrays.asList(classPath), classLoader);
        generator.generate(AotPhase.TEST, applicationStructure);
        return 0;
    }

    public static void main(String[] args) throws IOException {
        int exitCode = new CommandLine((Object)new GenerateTestBootstrapCommand()).execute(args);
        System.exit(exitCode);
    }
}

