/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aot.test.boot;

import java.util.Collection;
import java.util.Set;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationContextFactory;
import org.springframework.boot.ConfigurableBootstrapContext;
import org.springframework.boot.DefaultApplicationArguments;
import org.springframework.boot.DefaultBootstrapContext;
import org.springframework.boot.LazyInitializationBeanFactoryPostProcessor;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.config.ConfigDataEnvironmentPostProcessor;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.boot.logging.DeferredLogFactory;
import org.springframework.boot.logging.DeferredLogs;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.nativex.utils.NativeUtils;
import org.springframework.util.Assert;

class BuildTimeTestSpringApplication
extends SpringApplication {
    private ConfigurableEnvironment environment;
    private boolean lazyInitialization = false;
    private boolean allowBeanDefinitionOverriding = false;

    BuildTimeTestSpringApplication() {
        super(new Class[0]);
    }

    public void setEnvironment(ConfigurableEnvironment environment) {
        super.setEnvironment(environment);
        this.environment = environment;
    }

    public void setAllowBeanDefinitionOverriding(boolean allowBeanDefinitionOverriding) {
        super.setAllowBeanDefinitionOverriding(allowBeanDefinitionOverriding);
        this.allowBeanDefinitionOverriding = allowBeanDefinitionOverriding;
    }

    public void setLazyInitialization(boolean lazyInitialization) {
        super.setLazyInitialization(lazyInitialization);
        this.lazyInitialization = lazyInitialization;
    }

    public GenericApplicationContext run(String ... args) {
        DefaultApplicationArguments applicationArguments = new DefaultApplicationArguments(args);
        GenericApplicationContext context = this.createContext();
        context.setEnvironment(this.prepareEnvironment());
        this.prepareContext((ConfigurableApplicationContext)context, (ApplicationArguments)applicationArguments);
        return context;
    }

    private void prepareContext(ConfigurableApplicationContext context, ApplicationArguments applicationArguments) {
        this.configureIgnoreBeanInfo(context.getEnvironment());
        this.postProcessApplicationContext(context);
        this.applyInitializers(context);
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        beanFactory.registerSingleton("springApplicationArguments", (Object)applicationArguments);
        ((DefaultListableBeanFactory)beanFactory).setAllowBeanDefinitionOverriding(this.allowBeanDefinitionOverriding);
        if (this.lazyInitialization) {
            context.addBeanFactoryPostProcessor((BeanFactoryPostProcessor)new LazyInitializationBeanFactoryPostProcessor());
        }
        Set sources = this.getAllSources();
        Assert.notEmpty((Collection)sources, (String)"Sources must not be empty");
        this.load((ApplicationContext)context, sources.toArray(new Object[0]));
    }

    private GenericApplicationContext createContext() {
        return (GenericApplicationContext)ApplicationContextFactory.DEFAULT.create(this.getWebApplicationType());
    }

    private void configureIgnoreBeanInfo(ConfigurableEnvironment environment) {
        if (System.getProperty("spring.beaninfo.ignore") == null) {
            Boolean ignore = (Boolean)environment.getProperty("spring.beaninfo.ignore", Boolean.class, (Object)Boolean.TRUE);
            System.setProperty("spring.beaninfo.ignore", ignore.toString());
        }
    }

    private ConfigurableEnvironment prepareEnvironment() {
        ConfigurableEnvironment environment = this.environment != null ? this.environment : new StandardEnvironment();
        environment.setConversionService((ConfigurableConversionService)new ApplicationConversionService());
        ConfigurationPropertySources.attach((Environment)environment);
        ConfigDataEnvironmentPostProcessor configDataEnvironmentPostProcessor = new ConfigDataEnvironmentPostProcessor((DeferredLogFactory)new DeferredLogs(), (ConfigurableBootstrapContext)new DefaultBootstrapContext());
        configDataEnvironmentPostProcessor.postProcessEnvironment(environment, (SpringApplication)this);
        this.bindToSpringApplication(environment, this);
        environment.getPropertySources().addFirst((PropertySource)new PropertiesPropertySource("native", NativeUtils.getNativeProperties()));
        return environment;
    }

    private void bindToSpringApplication(ConfigurableEnvironment environment, SpringApplication application) {
        try {
            Binder.get((Environment)environment).bind("spring.main", Bindable.ofInstance((Object)application));
        }
        catch (Exception ex) {
            throw new IllegalStateException("Cannot bind to SpringApplication", ex);
        }
    }
}

