/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.condition;

import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.AnyNestedCondition;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnYarnClientCondition
extends AllNestedConditions {
    private static final String TOKEN_ENV = "HADOOP_TOKEN_FILE_LOCATION";

    OnYarnClientCondition() {
        super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
    }

    private static class YarnClusterCondition
    extends SpringBootCondition {
        private YarnClusterCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String tokenEnv = System.getenv(OnYarnClientCondition.TOKEN_ENV);
            if (!StringUtils.hasText((String)tokenEnv)) {
                tokenEnv = System.getProperty(OnYarnClientCondition.TOKEN_ENV);
            }
            if (tokenEnv == null) {
                return ConditionOutcome.match((String)"Did not found system environment variable HADOOP_TOKEN_FILE_LOCATION");
            }
            return ConditionOutcome.noMatch((String)"Found system environment variable HADOOP_TOKEN_FILE_LOCATION");
        }
    }

    private static class ForceYarnClusterCondition
    extends AnyNestedCondition {
        public ForceYarnClusterCondition() {
            super(ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION);
        }

        @ConditionalOnProperty(prefix="spring.yarn.client", name={"enabled"}, havingValue="true", matchIfMissing=false)
        static class ForceYarnClusterConditionEnabledConfig {
            ForceYarnClusterConditionEnabledConfig() {
            }
        }

        @Conditional(value={YarnClusterCondition.class})
        static class ForceYarnClusterConditionConfig {
            ForceYarnClusterConditionConfig() {
            }
        }
    }

    @ConditionalOnProperty(prefix="spring.yarn.client", name={"enabled"}, havingValue="true", matchIfMissing=true)
    static class ForcedOverride {
        ForcedOverride() {
        }
    }

    @Conditional(value={ForceYarnClusterCondition.class})
    static class MissingYarn {
        MissingYarn() {
        }
    }
}

