/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.util.StringUtils;
import org.springframework.yarn.am.YarnAppmaster;
import org.springframework.yarn.boot.support.CommandLineRunnerSupport;
import org.springframework.yarn.launch.ExitStatus;
import org.springframework.yarn.listener.AppmasterStateListener;

public class AppmasterLauncherRunner
extends CommandLineRunnerSupport
implements CommandLineRunner {
    private static final Log log = LogFactory.getLog(AppmasterLauncherRunner.class);
    private int containerCount = 1;
    @Autowired(required=false)
    private YarnAppmaster yarnAppmaster;

    public void run(String ... args) throws Exception {
        if (this.yarnAppmaster != null) {
            this.launchAppmaster(this.yarnAppmaster, args);
        }
    }

    public void setContainerCount(int containerCount) {
        this.containerCount = containerCount;
    }

    protected void launchAppmaster(YarnAppmaster appmaster, String[] parameters) {
        Properties properties = StringUtils.splitArrayElementsIntoProperties((String[])parameters, (String)"=");
        if (properties == null) {
            properties = new Properties();
        }
        if (!properties.containsKey("container-count")) {
            log.info((Object)("Setting container count set externally " + this.containerCount));
            properties.put("container-count", Integer.toString(this.containerCount));
        }
        appmaster.setParameters(properties);
        appmaster.setEnvironment(System.getenv());
        log.info((Object)("Running YarnAppmaster with parameters [" + StringUtils.arrayToCommaDelimitedString((Object[])parameters) + "]"));
        appmaster.addAppmasterStateListener(new AppmasterStateListener(){

            public void state(AppmasterStateListener.AppmasterState state) {
                if (state == AppmasterStateListener.AppmasterState.COMPLETED) {
                    AppmasterLauncherRunner.this.countDownLatch();
                    AppmasterLauncherRunner.this.exit(ExitStatus.COMPLETED.getExitCode());
                } else if (state == AppmasterStateListener.AppmasterState.FAILED) {
                    AppmasterLauncherRunner.this.countDownLatch();
                    AppmasterLauncherRunner.this.exit(ExitStatus.FAILED.getExitCode());
                }
            }
        });
        appmaster.submitApplication();
        if (this.isWaitLatch()) {
            log.info((Object)"Waiting latch to receive appmaster complete state");
            this.waitLatch();
            log.info((Object)"YarnAppmaster complete");
        }
    }
}

