/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli.shell;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.CandidateListCompletionHandler;
import jline.console.completer.Completer;
import jline.console.completer.CompletionHandler;
import org.fusesource.jansi.AnsiRenderer;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.CommandRunner;
import org.springframework.boot.cli.command.core.HelpCommand;
import org.springframework.boot.loader.tools.SignalUtils;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.cli.shell.AnsiString;
import org.springframework.yarn.boot.cli.shell.ClearCommand;
import org.springframework.yarn.boot.cli.shell.CommandCompleter;
import org.springframework.yarn.boot.cli.shell.EscapeAwareWhiteSpaceArgumentDelimiter;
import org.springframework.yarn.boot.cli.shell.ExitCommand;
import org.springframework.yarn.boot.cli.shell.PromptCommand;
import org.springframework.yarn.boot.cli.shell.RunProcessCommand;
import org.springframework.yarn.boot.cli.shell.ShellExitException;
import org.springframework.yarn.boot.cli.shell.ShellPrompts;

public class Shell {
    private final ShellCommandRunner commandRunner;
    private final ConsoleReader consoleReader;
    private final EscapeAwareWhiteSpaceArgumentDelimiter argumentDelimiter = new EscapeAwareWhiteSpaceArgumentDelimiter();
    private final ShellPrompts prompts = new ShellPrompts();

    public Shell(List<Command> commands) throws IOException {
        this.attachSignalHandler();
        this.consoleReader = new ConsoleReader();
        this.commandRunner = this.createCommandRunner(commands);
        this.initializeConsoleReader();
    }

    private ShellCommandRunner createCommandRunner(List<Command> commands) {
        ShellCommandRunner runner = new ShellCommandRunner();
        runner.addCommand((Command)new HelpCommand((CommandRunner)runner));
        if (commands != null) {
            runner.addCommands(commands);
        }
        runner.addCommand((Command)new PromptCommand(this.prompts));
        runner.addCommand((Command)new ClearCommand(this.consoleReader));
        runner.addCommand((Command)new ExitCommand());
        runner.addAliases("exit", "quit");
        runner.addAliases("help", "?");
        runner.addAliases("clear", "cls");
        return runner;
    }

    private void initializeConsoleReader() {
        this.consoleReader.setHistoryEnabled(true);
        this.consoleReader.setBellEnabled(false);
        this.consoleReader.setExpandEvents(false);
        this.consoleReader.addCompleter((Completer)new CommandCompleter(this.consoleReader, (ArgumentCompleter.ArgumentDelimiter)this.argumentDelimiter, (Iterable<Command>)((Object)this.commandRunner)));
        this.consoleReader.setCompletionHandler((CompletionHandler)new CandidateListCompletionHandler());
    }

    private void attachSignalHandler() {
        SignalUtils.attachSignalHandler((Runnable)new Runnable(){

            @Override
            public void run() {
                Shell.this.handleSigInt();
            }
        });
    }

    public void run() throws Exception {
        block2: {
            this.printBanner();
            try {
                this.runInputLoop();
            }
            catch (Exception ex) {
                if (ex instanceof ShellExitException) break block2;
                throw ex;
            }
        }
    }

    private void printBanner() {
        String version = this.getClass().getPackage().getImplementationVersion();
        version = version == null ? "" : " (v" + version + ")";
        System.out.println(this.ansi("Spring YARN Cli", AnsiRenderer.Code.BOLD).append(version, AnsiRenderer.Code.FAINT));
        System.out.println(this.ansi("Hit TAB to complete. Type 'help' and hit RETURN for help, and 'exit' to quit.", new AnsiRenderer.Code[0]));
    }

    private void runInputLoop() throws Exception {
        String line;
        while ((line = this.consoleReader.readLine(this.getPrompt())) != null) {
            while (line.endsWith("\\")) {
                line = line.substring(0, line.length() - 1);
                line = line + this.consoleReader.readLine("> ");
            }
            if (!StringUtils.hasLength((String)line)) continue;
            String[] args = this.argumentDelimiter.parseArguments(line);
            this.commandRunner.runAndHandleErrors(args);
        }
    }

    private String getPrompt() {
        String prompt = this.prompts.getPrompt();
        return this.ansi(prompt, AnsiRenderer.Code.FG_BLUE).toString();
    }

    private AnsiString ansi(String text, AnsiRenderer.Code ... codes) {
        return new AnsiString(this.consoleReader.getTerminal()).append(text, codes);
    }

    protected void handleSigInt() {
        if (this.commandRunner.handleSigInt()) {
            return;
        }
        System.out.println("\nThanks for using Spring Boot");
        System.exit(1);
    }

    private class ShellCommandRunner
    extends CommandRunner {
        private volatile Command lastCommand;
        private final Map<String, String> aliases;

        public ShellCommandRunner() {
            super(null);
            this.aliases = new HashMap<String, String>();
        }

        public void addAliases(String command, String ... aliases) {
            for (String alias : aliases) {
                this.aliases.put(alias, command);
            }
        }

        public Command findCommand(String name) {
            if (name.startsWith("!")) {
                return new RunProcessCommand(name.substring(1));
            }
            if (this.aliases.containsKey(name)) {
                name = this.aliases.get(name);
            }
            return super.findCommand(name);
        }

        protected void beforeRun(Command command) {
            this.lastCommand = command;
        }

        protected void afterRun(Command command) {
        }

        public boolean handleSigInt() {
            Command command = this.lastCommand;
            if (command != null && command instanceof RunProcessCommand) {
                return ((RunProcessCommand)command).handleSigInt();
            }
            return false;
        }
    }
}

