/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.yarn.boot.app.ClientApplicationRunner;
import org.springframework.yarn.boot.app.YarnPushApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnPushCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "push";
    public static final String DEFAULT_DESC = "Push new application version";

    public YarnPushCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new PushOptionHandler());
    }

    public YarnPushCommand(PushOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnPushCommand(String name, String description, PushOptionHandler handler) {
        super(name, description, handler);
    }

    public static class PushOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationVersionOption;

        protected final void options() {
            this.applicationVersionOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_VERSION, "Application version").withOptionalArg().defaultsTo((Object)"app", (Object[])new String[0]);
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appVersion = (String)options.valueOf(this.applicationVersionOption);
            YarnPushApplication app = new YarnPushApplication();
            app.applicationVersion(appVersion);
            Properties instanceProperties = new Properties();
            instanceProperties.setProperty("spring.yarn.applicationVersion", appVersion);
            app.configFile("application.properties", instanceProperties);
            this.handleApplicationRun((ClientApplicationRunner<String>)app);
        }

        @Override
        protected void handleApplicationRun(ClientApplicationRunner<String> app) {
            app.run();
            this.handleOutput("New version installed");
        }

        public OptionSpec<String> getApplicationVersionOption() {
            return this.applicationVersionOption;
        }
    }
}

