/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.cli;

import java.util.Properties;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.yarn.boot.app.YarnContainerClusterApplication;
import org.springframework.yarn.boot.cli.AbstractApplicationCommand;
import org.springframework.yarn.boot.cli.CliSystemConstants;

public class YarnClusterInfoCommand
extends AbstractApplicationCommand {
    public static final String DEFAULT_COMMAND = "clusterinfo";
    public static final String DEFAULT_DESC = "List cluster info";

    public YarnClusterInfoCommand() {
        super(DEFAULT_COMMAND, DEFAULT_DESC, new ClusterInfoOptionHandler());
    }

    public YarnClusterInfoCommand(ClusterInfoOptionHandler handler) {
        super(DEFAULT_COMMAND, DEFAULT_DESC, handler);
    }

    public YarnClusterInfoCommand(String name, String description, ClusterInfoOptionHandler handler) {
        super(name, description, handler);
    }

    public static class ClusterInfoOptionHandler
    extends AbstractApplicationCommand.ApplicationOptionHandler<String> {
        private OptionSpec<String> applicationIdOption;
        private OptionSpec<String> clusterIdOption;
        private OptionSpec<Boolean> verboseOption;

        protected final void options() {
            this.applicationIdOption = this.option(CliSystemConstants.OPTIONS_APPLICATION_ID, "Specify YARN application id").withRequiredArg();
            this.clusterIdOption = this.option(CliSystemConstants.OPTIONS_CLUSTER_ID, "Specify cluster id").withRequiredArg();
            this.verboseOption = this.option(CliSystemConstants.OPTIONS_VERBOSE, "Verbose output").withOptionalArg().ofType(Boolean.class).defaultsTo((Object)true, (Object[])new Boolean[0]);
        }

        @Override
        protected void verifyOptionSet(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            String clusterId = (String)options.valueOf(this.clusterIdOption);
            Assert.state((StringUtils.hasText((String)appId) && StringUtils.hasText((String)clusterId) ? 1 : 0) != 0, (String)"Cluster Id and Application Id must be defined");
        }

        @Override
        protected void runApplication(OptionSet options) throws Exception {
            String appId = (String)options.valueOf(this.applicationIdOption);
            String clusterId = (String)options.valueOf(this.clusterIdOption);
            YarnContainerClusterApplication app = new YarnContainerClusterApplication();
            Properties appProperties = new Properties();
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.operation", "CLUSTERINFO");
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.applicationId", appId);
            appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.clusterId", clusterId);
            if (this.isFlagOn(options, this.verboseOption)) {
                appProperties.setProperty("spring.yarn.internal.ContainerClusterApplication.verbose", "true");
            }
            app.appProperties(appProperties);
            this.handleApplicationRun(app);
        }

        public OptionSpec<String> getApplicationIdOption() {
            return this.applicationIdOption;
        }

        public OptionSpec<String> getClusterIdOption() {
            return this.clusterIdOption;
        }

        public OptionSpec<Boolean> getVerboseOption() {
            return this.verboseOption;
        }
    }
}

