/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.support;

import java.util.List;
import java.util.Map;
import org.springframework.util.ObjectUtils;

public class YarnBatchProperties {
    private String name;
    private boolean enabled = false;
    private List<JobProperties> jobs;
    private Map<Jobs2Enum, Object> test;

    public void setTest(Map<Jobs2Enum, Object> test) {
        this.test = test;
    }

    public Map<Jobs2Enum, Object> getTest() {
        return this.test;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public List<JobProperties> getJobs() {
        return this.jobs;
    }

    public void setJobs(List<JobProperties> jobs) {
        this.jobs = jobs;
    }

    public JobProperties getJobProperties(String jobName) {
        if (this.jobs != null) {
            for (JobProperties jp : this.jobs) {
                if (!ObjectUtils.nullSafeEquals((Object)jobName, (Object)jp.getName())) continue;
                return jp;
            }
        }
        return null;
    }

    public String toString() {
        return "SpringYarnBatchProperties [jobs=" + this.jobs + "]";
    }

    public static class JobProperties {
        private String name;
        private boolean enabled;
        private boolean next;
        private boolean failNext;
        private boolean restart;
        private boolean failRestart;
        private Map<String, Object> parameters;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isNext() {
            return this.next;
        }

        public void setNext(boolean next) {
            this.next = next;
        }

        public boolean isFailNext() {
            return this.failNext;
        }

        public void setFailNext(boolean failNext) {
            this.failNext = failNext;
        }

        public boolean isRestart() {
            return this.restart;
        }

        public void setRestart(boolean restart) {
            this.restart = restart;
        }

        public boolean isFailRestart() {
            return this.failRestart;
        }

        public void setFailRestart(boolean failRestart) {
            this.failRestart = failRestart;
        }

        public Map<String, Object> getParameters() {
            return this.parameters;
        }

        public void setParameters(Map<String, Object> parameters) {
            this.parameters = parameters;
        }

        public String toString() {
            return "Jobs [name=" + this.name + ", enabled=" + this.enabled + ", next=" + this.next + ", failNext=" + this.failNext + ", restart=" + this.restart + ", failRestart=" + this.failRestart + ", parameters=" + this.parameters + "]";
        }
    }

    public static enum Jobs2Enum {
        name,
        enabled;

    }
}

