/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.repository;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.OrderComparator;
import org.springframework.yarn.batch.repository.JobRepositoryRemoteServiceInterceptor;
import org.springframework.yarn.batch.repository.JobRepositoryService;
import org.springframework.yarn.integration.ip.mind.MindAppmasterService;
import org.springframework.yarn.integration.ip.mind.MindRpcMessageHolder;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;
import org.springframework.yarn.integration.ip.mind.binding.BaseResponseObject;

public class BatchAppmasterService
extends MindAppmasterService {
    private static final Log log = LogFactory.getLog(BatchAppmasterService.class);
    private JobRepositoryService jobRepositoryRemoteService;
    private final JobRepositoryServiceInterceptorList interceptors = new JobRepositoryServiceInterceptorList();

    protected MindRpcMessageHolder handleMindMessageInternal(MindRpcMessageHolder message) {
        BaseObject baseObject = (BaseObject)this.getConversionService().convert((Object)message, BaseObject.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Converted message into base object: " + baseObject));
        }
        BaseResponseObject baseResponseObject = (baseObject = this.interceptors.preRequest(baseObject)) == null ? this.interceptors.handleRequest(baseObject) : this.jobRepositoryRemoteService.get(baseObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Response from JobRepositoryRemoteService: " + baseResponseObject));
        }
        baseResponseObject = this.interceptors.postRequest(baseResponseObject);
        return (MindRpcMessageHolder)this.getConversionService().convert((Object)baseResponseObject, MindRpcMessageHolder.class);
    }

    public void setJobRepositoryRemoteService(JobRepositoryService jobRepositoryRemoteService) {
        this.jobRepositoryRemoteService = jobRepositoryRemoteService;
    }

    public void setInterceptors(List<JobRepositoryRemoteServiceInterceptor> interceptors) {
        Collections.sort(interceptors, new OrderComparator());
        this.interceptors.set(interceptors);
    }

    public void addInterceptor(JobRepositoryRemoteServiceInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    protected JobRepositoryServiceInterceptorList getInterceptors() {
        return this.interceptors;
    }

    protected class JobRepositoryServiceInterceptorList {
        private final List<JobRepositoryRemoteServiceInterceptor> interceptors = new CopyOnWriteArrayList<JobRepositoryRemoteServiceInterceptor>();

        protected JobRepositoryServiceInterceptorList() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean set(List<JobRepositoryRemoteServiceInterceptor> interceptors) {
            List<JobRepositoryRemoteServiceInterceptor> list = interceptors;
            synchronized (list) {
                interceptors.clear();
                return interceptors.addAll(interceptors);
            }
        }

        public boolean add(JobRepositoryRemoteServiceInterceptor interceptor) {
            return this.interceptors.add(interceptor);
        }

        public BaseObject preRequest(BaseObject baseObject) {
            for (JobRepositoryRemoteServiceInterceptor interceptor : this.interceptors) {
                baseObject = interceptor.preRequest(baseObject);
                if (baseObject != null) continue;
                return null;
            }
            return baseObject;
        }

        public BaseResponseObject handleRequest(BaseObject baseObject) {
            BaseResponseObject ret = null;
            for (JobRepositoryRemoteServiceInterceptor interceptor : this.interceptors) {
                ret = interceptor.handleRequest(baseObject);
                if (ret == null) continue;
                return ret;
            }
            return ret;
        }

        public BaseResponseObject postRequest(BaseResponseObject baseResponseObject) {
            for (JobRepositoryRemoteServiceInterceptor interceptor : this.interceptors) {
                baseResponseObject = interceptor.postRequest(baseResponseObject);
            }
            return baseResponseObject;
        }
    }
}

